% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create-wp-post.R
\name{create_wp_post}
\alias{create_wp_post}
\title{Create a New WordPress Page}
\usage{
create_wp_post(
  root_url,
  user,
  pass,
  title_val,
  excerpt_val = "",
  content_val,
  fifu_val = NULL,
  status_val,
  author_val,
  format_val = "standard",
  categories_val,
  tag_val = ""
)
}
\arguments{
\item{root_url}{The domain on which you wish to create the post.}

\item{user}{The username to be passed into the API call to create the post.}

\item{pass}{The password to be used in the API call to create the post. To get this value,
you must have the Application Passwords plugin
installed, and must create an application using that plugin via your WordPress admin panel;
there you will get the password needed.}

\item{title_val}{The title of the page you are creating.}

\item{excerpt_val}{The excerpt to be shown where your WordPress features excerpts of post.}

\item{content_val}{The content of the post.}

\item{fifu_val}{If the Featured Image From URL plugin is installed, users can specify a
remotely hosted image file to use as the featured image for the post.
This field defaults to a value of NULL.}

\item{status_val}{The status of the post. Can be one of 'draft','publish','pending','future','private'.}

\item{author_val}{The user ID of the author creating the post.}

\item{format_val}{The WordPress format to use. Defaults to 'standard'.}

\item{categories_val}{The category IDs the post is to be associated with; comma separate in a
character string if more than one.}

\item{tag_val}{The tag IDs the post is to be associated with;
comma separate in a category string if more than one.}
}
\value{
A tibble containing the arguments passed in as well as the URL retrieved from the
API response.
}
\description{
wCreates a new post on the WordPress site provided using the credentials entered,
with content and other information provided.
}
\examples{
\dontrun{
create_wp_post(root_url = 'https://domain.com',user = Sys.getenv('username'),
pass = Sys.getenv('password'),
title_val = 'post title',excerpt_val = 'post excerpt',
content_val = 'the post content as a string, with wordpress-accepted
<strong>html</strong> (or bbcode!)',
fifu_val = 'https://domain.com/image.png',
status_val = 'draft',format_val = 'standard',categories_val = 1, tag_val = 1)
}

}
