% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wkb.R, R/wkt.R
\name{wkb}
\alias{wkb}
\alias{as_wkb}
\alias{as_wkb.character}
\alias{as_wkb.wk_wkb}
\alias{as_wkb.wk_wkt}
\alias{as_wkt.wk_wkb}
\title{Mark lists of raw vectors as well-known binary}
\usage{
wkb(x)

as_wkb(x, ...)

\method{as_wkb}{character}(x, ...)

\method{as_wkb}{wk_wkb}(
  x,
  ...,
  include_z = NULL,
  include_m = NULL,
  include_srid = NULL,
  endian = NULL
)

\method{as_wkb}{wk_wkt}(
  x,
  ...,
  include_z = NULL,
  include_m = NULL,
  include_srid = NULL,
  endian = NULL
)

\method{as_wkt}{wk_wkb}(
  x,
  ...,
  include_z = NULL,
  include_m = NULL,
  include_srid = NULL,
  precision = NULL,
  trim = NULL
)
}
\arguments{
\item{x}{A \code{\link[=list]{list()}} of \code{\link[=raw]{raw()}} vectors or \code{NULL}.}

\item{...}{Unused}

\item{include_z}{Include the
values of the Z and M coordinates and/or SRID
in the output? Use \code{FALSE} to omit, \code{TRUE} to include, or \code{NA} to include
only if present. Note that using \code{TRUE} may result in an error if there
is no value present in the original.}

\item{include_m}{Include the
values of the Z and M coordinates and/or SRID
in the output? Use \code{FALSE} to omit, \code{TRUE} to include, or \code{NA} to include
only if present. Note that using \code{TRUE} may result in an error if there
is no value present in the original.}

\item{include_srid}{Include the
values of the Z and M coordinates and/or SRID
in the output? Use \code{FALSE} to omit, \code{TRUE} to include, or \code{NA} to include
only if present. Note that using \code{TRUE} may result in an error if there
is no value present in the original.}

\item{endian}{For WKB writing, 0 for big endian, 1 for little endinan.
Defaults to \code{\link[=wk_platform_endian]{wk_platform_endian()}} (slightly faster).}

\item{precision}{The rounding precision to use when writing
(number of decimal places).}

\item{trim}{Trim unnecessary zeroes in the output?}
}
\value{
A \code{\link[=new_wk_wkb]{new_wk_wkb()}}
}
\description{
Mark lists of raw vectors as well-known binary
}
\examples{
wkb(wkt_translate_wkb("POINT (20 10)"))

}
