% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/db.R
\name{with_db_connection}
\alias{with_db_connection}
\alias{local_db_connection}
\title{DBMS Connections which disconnect themselves.}
\usage{
with_db_connection(con, code)

local_db_connection(con, .local_envir = parent.frame())
}
\arguments{
\item{con}{For \code{with_db_connection()} a named list with the connection(s) to
create. For \code{local_db_connection()} the code to create a single connection,
which is then returned.}

\item{code}{\code{[any]}\cr Code to execute in the temporary environment}

\item{.local_envir}{\verb{[environment]}\cr The environment to use for scoping.}
}
\value{
\code{[any]}\cr The results of the evaluation of the \code{code}
argument.
}
\description{
Connections to Database Management Systems which automatically disconnect. In
particular connections which are created with \code{DBI::dbConnect()} and closed
with \code{DBI::dbDisconnect()}.
}
\examples{
db <- tempfile()
with_db_connection(
  list(con = DBI::dbConnect(RSQLite::SQLite(), db)), {
    DBI::dbWriteTable(con, "mtcars", mtcars)
})

head_db_table <- function(...) {
  con <- local_db_connection(DBI::dbConnect(RSQLite::SQLite(), db))
  head(DBI::dbReadTable(con, "mtcars"), ...)
}
head_db_table()
unlink(db)
}
\seealso{
\code{\link{withr}} for examples
}
