% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coords_to_raster.R
\name{coords_to_raster}
\alias{coords_to_raster}
\title{Create a raster from coordinates}
\usage{
coords_to_raster(
  coords,
  buffer = 0,
  res = 1,
  agg = NULL,
  disagg = NULL,
  plot = FALSE
)
}
\arguments{
\item{coords}{coordinates of samples as sf points, a SpatVector, a two-column matrix, or a data.frame with x and y coordinates}

\item{buffer}{size of buffer to add to edge of raster (defaults to 0)}

\item{res}{desired resolution of raster (defaults to 1). Can be a single value for square cells or a vector with two values representing x and y resolutions}

\item{agg}{aggregation factor to apply to raster (defaults to NULL)}

\item{disagg}{disaggregation factor to apply to raster (defaults to NULL)}

\item{plot}{whether to plot resulting raster with coords (defaults to FALSE)}
}
\value{
RasterLayer
}
\description{
Generate a raster layer from coordinates which can be used in \link[wingen]{window_gd} as the RasterLayer to move the window across
}
\examples{
load_mini_ex()
coords_to_raster(mini_coords, buffer = 1, plot = TRUE)
}
