% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visibility.R
\name{plot_viewshed}
\alias{plot_viewshed}
\title{plot_viewshed}
\usage{
plot_viewshed(res, legend = FALSE)
}
\arguments{
\item{res}{The resulting list from viewshed}

\item{legend}{Plot a legend? Default is FALSE}
}
\description{
Plot the result of viewshed
}
\examples{
\dontrun{
library(sp)
library(raster)
Polygon1 <- Polygon(rbind(c(4488182, 2667172), c(4488182, 2669343),
                          c(4499991, 2669343), c(4499991, 2667172)))
Polygon1 <- Polygons(list(Polygon1), 1);
Polygon1 <- SpatialPolygons(list(Polygon1))
Projection <- "+proj=laea +lat_0=52 +lon_0=10 +x_0=4321000 +y_0=3210000
+ellps=GRS80 +towgs84=0,0,0,0,0,0,0 +units=m +no_defs"
proj4string(Polygon1) <- CRS(Projection)
DEM_meter <- getDEM(Polygon1)

sample_POI <- spsample(DEM_meter[[2]], n = ncell(DEM_meter[[1]]), type = "regular")
sample_xy <- coordinates(sample_POI)

turbloc = spsample(DEM_meter[[2]], 10, type = "random");
res <- viewshed(r = DEM_meter[[1]], shape=DEM_meter[[2]], turbine_locs = turbloc,  h1=1.8, h2=50)
plot_viewshed(res)
}
}
\author{
Sebastian Gatscha
}
