% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotWindrose.R
\name{plotWindrose}
\alias{plotWindrose}
\title{Plot a Windrose}
\usage{
plotWindrose(data, spd, dir, spdres = 2, dirres = 10, spdmin = 1,
  spdmax = 30, palette = "YlGnBu", spdseq = NULL, plotit = TRUE)
}
\arguments{
\item{data}{A data.frame containing the wind information}

\item{spd}{The column of the wind speeds in "data"}

\item{dir}{The column of the wind directions in "data"}

\item{spdres}{The increment of the wind speed legend. Default is 2}

\item{dirres}{The size of the wind sectors. Default is 10}

\item{spdmin}{Minimum wind speed. Default is 1}

\item{spdmax}{Maximal wind speed. Default is 30}

\item{palette}{A color palette used for drawing the wind rose}

\item{spdseq}{A wind speed sequence, that is used for plotting}

\item{plotit}{Should the windrose be plotted? Default is TRUE}
}
\description{
Plot a wind rose of the wind data frame.
}
\examples{
## Exemplary Input Wind speed and direction data frame
# Uniform wind speed and single wind direction
data.in <- data.frame(ws = 12, wd = 0)
windrosePlot <- plotWindrose(data = data.in, spd = data.in$ws,
   dir = data.in$wd)

# Random wind speeds and random wind directions
data.in <- data.frame(ws = sample(1:25, 10), 
                      wd = sample(1:260, 10))
windrosePlot <- plotWindrose(data = data.in, spd = data.in$ws,
   dir = data.in$wd)

}
\author{
Sebastian Gatscha
}
