% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Ca.R
\name{Ca}
\alias{Ca}
\title{Coefficient of Association}
\usage{
Ca(traj1, traj2, tc = 0, dc = 0)
}
\arguments{
\item{traj1}{an object of the class \code{ltraj} which contains the time-stamped 
movement fixes of the first object. Note this object must be a \code{type II 
ltraj} object. For more information on objects of this type see \code{
help(ltraj)}.}

\item{traj2}{same as \code{traj1}.}

\item{tc}{temporal tolerance limit (in seconds) for defining when two fixes
are simultaneous or together. Parameter passed to function \code{GetSimultaneous}.}

\item{dc}{distance tolerance limit (in appropriate units) for defining when 
two fixes are spatially together.}
}
\value{
This function returns a numeric result of the Ca statistic.
}
\description{
This function measures the dynamic interaction between two moving objects following
 the methods first described by Cole (1949), and more recently employed by Bauman (1998).
}
\details{
This function can be used to calculate the Cole (1949) measure of dynamic
 interaction between two animals. Termed a coefficient of association, the Ca
 statistic tests the number of fixes the animals are observed together against the
 total number of fixes following:
 \deqn{Ca = \frac{2AB}{A+B}}{2AB/(A+B)}
 where \eqn{A} (respectively \eqn{B}) is the number of times animal 1 (resp. 2) are
 observed, and \eqn{AB} is the number of times the two animals are observed together.
 Several works, including Bauman (1998) have suggested that Ca > 0.5 indicates
 affiliation or fidelity, while Ca < 0.5 indicates no association between the
 two animals. Note that this function calls \code{GetSimultaneous} to identify the temporal
 component of identifying when fixes together.
}
\examples{
data(deer)
deer37 <- deer[1]
deer38 <- deer[2]
#tc = 7.5 minutes, dc = 50 meters
Ca(deer37, deer38, tc = 7.5*60, dc = 50)

}
\references{
Bauman, P.J. (1998) The Wind Cave National Park elk herd: home ranges, seasonal movements, and alternative control methods.
   M.S. Thesis. South Dakota State University, Brookings, South Dakota, USA. \cr\cr
 Cole, L.C. (1949) The measurement of interspecific association. \emph{Ecology}. \bold{30}, 411--424.
}
\seealso{
GetSimultaneous, Prox, HAI
}
\keyword{indices}
