% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wikispecies.R
\name{wt_wikispecies}
\alias{wt_wikispecies}
\alias{wt_wikispecies_parse}
\alias{wt_wikispecies_search}
\title{WikiSpecies}
\usage{
wt_wikispecies(name, utf8 = TRUE, ...)

wt_wikispecies_parse(page, types = c("langlinks", "iwlinks", "externallinks",
  "common_names", "classification"), tidy = FALSE)

wt_wikispecies_search(query, limit = 10, offset = 0, utf8 = TRUE, ...)
}
\arguments{
\item{name}{(character) Wiki name - as a page title, must be length 1}

\item{utf8}{(logical) If `TRUE`, encodes most (but not all) non-ASCII
characters as UTF-8 instead of replacing them with hexadecimal escape
sequences. Default: `TRUE`}

\item{...}{curl options, passed on to [httr::GET()]}

\item{page}{([httr::response()]) Result of [wt_wiki_page()]}

\item{types}{(character) List of properties to parse}

\item{tidy}{(logical). tidy output to data.frame's if possible.
Default: `FALSE`}

\item{query}{(character) query terms}

\item{limit}{(integer) number of results to return. Default: 10}

\item{offset}{(integer) record to start at. Default: 0}
}
\value{
\code{wt_wikispecies} returns a list, with slots:
\itemize{
\item langlinks - language page links
\item externallinks - external links
\item common_names - a data.frame with \code{name} and \code{language} columns
\item classification - a data.frame with \code{rank} and \code{name} columns
}

\code{wt_wikispecies_parse} returns a list

\code{wt_wikispecies_search} returns a list with slots for \code{continue} and
\code{query}, where \code{query} holds the results, with \code{query$search} slot with
the search results
}
\description{
WikiSpecies
}
\examples{
# high level
wt_wikispecies(name = "Malus domestica")

# low level
pg <- wt_wiki_page("https://species.wikimedia.org/wiki/Abelmoschus")
wt_wikispecies_parse(pg)

# search wikispecies
wt_wikispecies_search(query = "pine tree")

## use search results to dig into pages
res <- wt_wikispecies_search(query = "pine tree")
lapply(res$query$search$title[1:3], wt_wikispecies)
}
\references{
\url{https://www.mediawiki.org/wiki/API:Search} for help on search
}
