% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wiki_utils.R
\name{w_IdentifiersOfAuthority}
\alias{w_IdentifiersOfAuthority}
\title{Search for Wikidata entities that have a property identifier}
\usage{
w_IdentifiersOfAuthority(Pauthority, langsorder = "en", instanceof = "")
}
\arguments{
\item{Pauthority}{Wikidata property identifier for the authority, i.e, the
property of Wikidata for the the database of the authority. For example, is
Pauthority = "P4439", then search Wikidata entities that have an identifier
in the MNCARS (Museo Nacional Centro de Arte Reina Sofía) authority database.}

\item{langsorder}{Order of languages in which the information will be
returned, separated with '|'. If no information is given in the first
language, next is used. This parameter is mandatory, at least one language is
required, default, 'en'.}

\item{instanceof}{Wikidata entity of which the entities searched for are an
example or member of it (class). Optional. For example, if instanceof="Q5"
the search are filtered to Wikidata entities of class Q5 (human). Some
entity classes are allowed, separated with '|'.}
}
\value{
A data-frame with 'entity', 'entityLabel', 'entityDescription' and
the identifier in the "Pauthority" database,
}
\description{
Search for Wikidata entities that have an identifier in the Wikidata
authority property "Pauthority". Return the entities and information (label,
description) in the language order indicated in langsorder. If instanceof
has a value, then response is limited to entities which are instance of it.
}
\examples{
\dontrun{
# Example: Pauthority=P4439 (has identificator in the Museo Nacional Centro de
# Arte Reina Sofía)
mncars   <- w_IdentifiersOfAuthority(Pauthority="P4439",
langsorder = 'es|en')  # 1286  [human, groups, etc.]
mncarsQ5 <- w_IdentifiersOfAuthority(Pauthority="P4439", langsorder = 'es|en',
instanceof = 'Q5')  # 1280
# Wikidata entities are not 'human' (Q5) (see entityDescription column):
mncars[!(mncars$entity \%in\% mncarsQ5$entity),]  # not instance of Q5.
}
}
\author{
Angel Zazo, Department of Computer Science and Automatics, University of Salamanca
}
