% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lidar_analysis.R
\name{wbt_individual_tree_detection}
\alias{wbt_individual_tree_detection}
\title{Individual tree detection}
\usage{
wbt_individual_tree_detection(
  input,
  output = NULL,
  min_search_radius = 1,
  min_height = 0,
  max_search_radius = "",
  max_height = "",
  only_use_veg = FALSE,
  wd = NULL,
  verbose_mode = FALSE,
  compress_rasters = FALSE,
  command_only = FALSE
)
}
\arguments{
\item{input}{Name of the input LiDAR file.}

\item{output}{Name of the output vector points file.}

\item{min_search_radius}{Minimum search radius (m).}

\item{min_height}{Minimum height (m).}

\item{max_search_radius}{Maximum search radius (m).}

\item{max_height}{Maximum height (m).}

\item{only_use_veg}{Only use veg. class points?.}

\item{wd}{Changes the working directory.}

\item{verbose_mode}{Sets verbose mode. If verbose mode is \code{FALSE}, tools will not print output messages.}

\item{compress_rasters}{Sets the flag used by 'WhiteboxTools' to determine whether to use compression for output rasters.}

\item{command_only}{Return command that would be executed by \code{system()} rather than running tool.}
}
\value{
Returns the tool text outputs.
}
\description{
Identifies points in a LiDAR point cloud that are associated with the tops of individual trees.
}
\keyword{LiDARTools}
