% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/production.R
\name{get_primary_residues}
\alias{get_primary_residues}
\title{Crop residue items}
\usage{
get_primary_residues(version = NULL)
}
\arguments{
\item{version}{File version to use as input. See \link{whep_inputs} for details.}
}
\value{
A tibble with the crop residue data.
It contains the following columns:
\itemize{
\item \code{year}: The year in which the recorded event occurred.
\item \code{area_code}: The code of the country where the data is from. For code
details see e.g. \code{add_area_name()}.
\item \code{item_cbs_code_crop}: FAOSTAT internal code for each commodity balance
sheet item. This is the crop that is generating the residue.
\item \code{item_cbs_code_residue}: FAOSTAT internal code for each commodity balance
sheet item. This is the obtained residue. In the commodity balance sheet,
this can be three different items right now:
\itemize{
\item \code{2105}: \code{Straw}
\item \code{2106}: \verb{Other crop residues}
\item \code{2107}: \code{Firewood}
}

These are actually not FAOSTAT defined items, but custom defined by us.
When necessary, FAOSTAT codes are extended for our needs.
\item \code{value}: The amount of residue produced, measured in tonnes.
}
}
\description{
Get type and amount of residue produced for each crop production item.
}
\examples{
# Note: These are smaller samples to show outputs, not the real data.
# For all data, call the function with default version (i.e. no arguments).
get_primary_residues(version = "20250721T150132Z-dfd94")
}
