% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/colors.R
\name{wes_palette}
\alias{wes_palette}
\title{A Wes Anderson palette generator}
\usage{
wes_palette(name, n, type = c("discrete", "continuous"))
}
\arguments{
\item{name}{Name of desired palette. Choices are:
\code{GrandBudapest}, \code{Moonrise1},  \code{Royal1},
\code{Moonrise2}, \code{Cavalcanti},  \code{Royal2}, \code{GrandBudapest2},
\code{Moonrise3},  \code{Chevalier} , \code{BottleRocket} ,
\code{darjeeling}, \code{darjeeling2}}

\item{n}{Number of colors desired. Unfortunately most palettes now only
have 4 or 5 colors. But hopefully we'll add more palettes soon. All color
schemes are derived from the most excellent Tumblr blog:
\href{http://wesandersonpalettes.tumblr.com/}{Wes Anderson Palettes}.
If omitted, uses all colours.}

\item{type}{Either "continuous" or "discrete". Use continuous if you want
to automatically interpolate between colours.}
}
\value{
A vector of colours.
}
\description{
These are a handful of color palettes from Wes Anderson movies.
}
\examples{
wes_palette("Royal1")
wes_palette("GrandBudapest")
wes_palette("Cavalcanti")
wes_palette("Cavalcanti", 3)

# If you need more colours than normally found in a palette, you
# can use a continuous palette to interpolate between existing
# colours
pal <- wes_palette(21, name = "Zissou", type = "continuous")
image(volcano, col = pal)
}
\keyword{colors}

