# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

bounding_wkt_points <- function(min_x, max_x, min_y, max_y) {
    .Call(`_wellknown_bounding_wkt_points`, min_x, max_x, min_y, max_y)
}

bounding_wkt_list <- function(x) {
    .Call(`_wellknown_bounding_wkt_list`, x)
}

#' @title Extract Centroid
#' @description `get_centroid` identifies the 2D centroid
#' in a WKT object (or vector of WKT objects). Note that it assumes
#' cartesian values.
#' @export
#' @param wkt a character vector of WKT objects, represented as strings
#' @return a data.frame of two columns, `lat` and `lng`,
#' with each row containing the centroid from the corresponding wkt
#' object. In the case that the object is NA (or cannot be decoded)
#' the resulting values will also be NA
#' @seealso [wkt_coords()] to extract all coordinates, and
#' [wkt_bounding()] to extract a bounding box.
#' @examples
#' wkt_centroid("POLYGON((2 1.3,2.4 1.7))")
wkt_centroid <- function(wkt) {
    .Call(`_wellknown_wkt_centroid`, wkt)
}

#' @title Reverses the points within a geometry.
#' @description `wkt_reverse` reverses the points in any of
#' point, multipoint, linestring, multilinestring, polygon, or
#' multipolygon
#' @export
#' @param x a character vector of WKT objects, represented as strings
#' @return a string, same length as given
#' @details segment, box, and ring types not supported
#' @examples
#' wkt_reverse("POLYGON((42 -26,42 -13,52 -13,52 -26,42 -26))")
wkt_reverse <- function(x) {
    .Call(`_wellknown_wkt_reverse`, x)
}

#' @title Validate WKT objects
#' @description `validate_wkt` takes a vector of WKT objects and validates
#' them, returning a data.frame containing the status of each entry and
#' (in the case it cannot be parsed) any comments as to what, in particular,
#' may be wrong with it. It does not, unfortunately, check whether the
#' object meets the WKT spec - merely that it is formatted correctly.
#' @export
#' @param x a character vector of WKT objects.
#' @return a data.frame of two columns, `is_valid` (containing
#' `TRUE` or `FALSE` values for whether the WKT object is parseable and
#' valid) and `comments` (containing any error messages
#' in the case that the WKT object is not). If the objects are simply NA,
#' both fields will contain NA.
#' @seealso [wkt_correct()] for correcting WKT objects
#' that fail validity checks due to having a non-default orientation.
#' @examples
#' wkt <- c("POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))",
#'  "ARGHLEFLARFDFG",
#'  "LINESTRING (30 10, 10 90, 40 some string)")
#' validate_wkt(wkt)
validate_wkt <- function(x) {
    .Call(`_wellknown_validate_wkt`, x)
}

#' @title Convert WKT Objects into Bounding Boxes
#' @description `wkt_bounding` turns WKT objects (specifically points, 
#' linestrings, polygons, and multi-points/linestrings/polygons) into 
#' bounding boxes.
#' @export
#' @param wkt a character vector of WKT objects.
#' @param as_matrix whether to return the results as a matrix (`TRUE`)
#' or data.frame (`FALSE`). Set to `FALSE` by default.
#' @return either a data.frame or matrix, depending on the value of
#' `as_matrix`, containing four columns - `min_x`, `min_y`, `max_x` and 
#' `max_y` - representing the various points of the bounding box. In the
#' event that a valid bounding box cannot be generated
#' (due to the invalidity or incompatibility of the WKT object), NAs will
#' be returned.
#' @seealso [bounding_wkt()], to turn R-size bounding boxes into WKT objects
#' @examples
#' wkt_bounding("POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))")
wkt_bounding <- function(wkt, as_matrix = FALSE) {
    .Call(`_wellknown_wkt_bounding`, wkt, as_matrix)
}

#' @title Extract Latitude and Longitude from WKT polygons
#' @description `wkt_coords` extracts lat/long values from WKT polygons,
#' specifically the outer shell of those polygons (working on the assumption
#' that said outer edge is what you want).
#' 
#' Because it assumes **coordinates**, it also assumes a sphere - say, the
#' earth - and uses spherical coordinate values.
#' @export
#' @param wkt a character vector of WKT objects
#' @return a data.frame of four columns; `object` (containing which object
#' the row refers to), `ring` containing which layer of the object the row
#' refers to, `lng` and `lat`.
#' @seealso [wkt_bounding()] to extract a bounding box, and [wkt_centroid()]
#' to extract the centroid.
#' @examples
#' wkt_coords("POLYGON ((30 10, 40 40, 20 40, 10 20, 30 10))")
wkt_coords <- function(wkt) {
    .Call(`_wellknown_wkt_coords`, wkt)
}

#' @title Correct Incorrectly Oriented WKT Objects
#' @description `wkt_correct` does precisely what it says on the tin,
#' correcting the orientation of WKT objects that are improperly oriented
#' (say, back to front). It can be applied to WKT objects that,
#' when validated with [validate_wkt()], fail for that reason.
#' @export
#' @param x a character vector of WKT objects to correct
#' @return a character vector, the same length as `x`, containing
#' either the original value (if there was no correction to make, or if
#' the object was invalid for other reasons) or the corrected WKT
#' value.
#' @examples
#' # A WKT object
#' wkt <- "POLYGON((30 20, 10 40, 45 40, 30 20), (15 5, 5 10, 10 20, 40 10, 15 5))"
#' 
#' # That's invalid due to a non-default orientation
#' validate_wkt(wkt)
#' 
#' # And suddenly isn't!
#' wkt_correct(wkt)
wkt_correct <- function(x) {
    .Call(`_wellknown_wkt_correct`, x)
}

