% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ml_estimation.R
\encoding{UTF-8}
\name{loglik_profiling}
\alias{loglik_profiling}
\title{Log-Likelihood Profile Function for Parametric Lifetime Distributions with Threshold}
\usage{
loglik_profiling(
  x,
  status,
  thres,
  distribution = c("weibull3", "lognormal3", "loglogistic3")
)
}
\arguments{
\item{x}{A numeric vector which consists of lifetime data. Lifetime data
could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{status}{A vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{thres}{A numeric value for the threshold parameter.}

\item{distribution}{Supposed three-parametric distribution of the random variable.}
}
\value{
Returns the log-likelihood value for the data with respect to the threshold
parameter \code{thres}.
}
\description{
This function evaluates the log-likelihood with respect to a given threshold
parameter of a three-parametric lifetime distribution. In terms of
\emph{Maximum Likelihood Estimation} this function can be optimized (\code{\link{optim}})
to estimate the threshold parameter.
}
\examples{
# Vectors:
cycles <- alloy$cycles
status <- alloy$status

# Determining the optimal loglikelihood value:
## Range of threshold parameter must be smaller than the first failure:
threshold <- seq(
  0,
  min(cycles[status == 1]) - 0.1,
  length.out = 50
)

## loglikelihood value with respect to threshold values:
profile_logL <- loglik_profiling(
  x = cycles,
  status = status,
  thres = threshold,
  distribution = "weibull3"
)

## Threshold value (among the candidates) that maximizes the
## loglikelihood:
threshold[which.max(profile_logL)]

## plot:
plot(
  threshold,
  profile_logL,
  type = "l"
)
abline(
  v = threshold[which.max(profile_logL)],
  h = max(profile_logL),
  col = "red"
)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
