% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_estimators.R
\encoding{UTF-8}
\name{ml_estimation}
\alias{ml_estimation}
\title{ML Estimation for Parametric Lifetime Distributions}
\usage{
ml_estimation(x, event, distribution = c("weibull", "lognormal",
  "loglogistic", "normal", "logistic", "sev", "weibull3", "lognormal3",
  "loglogistic3"), wts = rep(1, length(x)), conf_level = 0.95,
  details = TRUE)
}
\arguments{
\item{x}{a numeric vector which consists of lifetime data. Lifetime
data could be every characteristic influencing the reliability of a product,
e.g. operating time (days/months in service), mileage (km, miles), load
cycles.}

\item{event}{a vector of binary data (0 or 1) indicating whether unit \emph{i}
is a right censored observation (= 0) or a failure (= 1).}

\item{distribution}{supposed distribution of the random variable. The
value can be \code{"weibull"}, \code{"lognormal"}, \code{"loglogistic"},
\code{"normal"}, \code{"logistic"}, \code{"sev"} \emph{(smallest extreme value)},
\code{"weibull3"}, \code{"lognormal3"} or \code{"loglogistic3"}.
Other distributions have not been implemented yet.}

\item{wts}{optional vector of case weights. The length of \code{wts} must be the
same as the number of observations \code{x}. Default is that \code{wts} is a
vector with all components being 1 (same weights).}

\item{conf_level}{confidence level of the interval. The default value is
\code{conf_level = 0.95}.}

\item{details}{a logical variable, where the default value is \code{TRUE}.
If \code{FALSE} the output consists of a list that only contains the
estimated parameters. If \code{TRUE} the output is a detailed list with
many more information. See below (\strong{Value}).}
}
\value{
Returns a list with the following components (depending on
\code{details} argument):
  \itemize{
  \item \code{coefficients} : Provided, if \code{distribution} is \code{"weibull"}.
    \eqn{\eta} is the estimated scale and \eqn{\beta} the estimated shape parameter.
  \item \code{confint} : Provided, if \code{distribution} is \code{"weibull"}.
    Confidence interval for \eqn{\eta} and \eqn{\beta}.
  \item \code{loc_sc_coefficients} : Estimated location-scale parameters.
  \item \code{loc_sc_confint} : Confidence interval for location-scale parameters.
  \item \code{loc_sc_vcov} : Estimated Variance-Covariance matrix of the used
    location-scale distribution.
  \item \code{logL} : The log-likelihood value.
  \item \code{aic} : Akaike Information Criterion.
  \item \code{bic} : Bayesian Information Criterion.}
}
\description{
This method estimates the parameters and calculates normal approximation confidence
intervals for a two- or three-parametric lifetime distribution in the frequently used
(log-) location-scale parameterization. \code{ml_estimation} uses the
\code{\link{Lifedata.MLE}} function which is defined in the
\emph{SPREDA} package.
For the Weibull the estimates are transformed such that they are in line with
the parameterization provided by the \emph{stats} package like
\code{\link{pweibull}}. The method is applicable for complete and (multiple)
right censored data.
}
\examples{
# Example 1: Fitting a two-parameter Weibull:
obs   <- seq(10000, 100000, 10000)
state <- c(0, 1, 1, 0, 0, 0, 1, 0, 1, 0)

mle <- ml_estimation(x = obs, event = state,
                     distribution = "weibull", conf_level = 0.90)

# Example 2: Fitting a three-parameter Weibull:
# Alloy T7987 dataset taken from Meeker and Escobar(1998, p. 131)
cycles   <- c(300, 300, 300, 300, 300, 291, 274, 271, 269, 257, 256, 227, 226,
              224, 213, 211, 205, 203, 197, 196, 190, 189, 188, 187, 184, 180,
              180, 177, 176, 173, 172, 171, 170, 170, 169, 168, 168, 162, 159,
              159, 159, 159, 152, 152, 149, 149, 144, 143, 141, 141, 140, 139,
              139, 136, 135, 133, 131, 129, 123, 121, 121, 118, 117, 117, 114,
              112, 108, 104, 99, 99, 96, 94)
state <- c(rep(0, 5), rep(1, 67))

mle_weib3 <- ml_estimation(x = cycles, event = state,
                           distribution = "weibull3", conf_level = 0.95)

}
\references{
Meeker, William Q; Escobar, Luis A., Statistical methods for
  reliability data, New York: Wiley series in probability and statistics, 1998
}
