% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_draft.R
\name{wnba_drafthistory}
\alias{wnba_drafthistory}
\title{\strong{Get WNBA Stats API Draft History}}
\usage{
wnba_drafthistory(
  league_id = "10",
  college = "",
  overall_pick = "",
  round_pick = "",
  round_num = "",
  season = most_recent_wnba_season() - 1,
  team_id = "",
  top_x = "",
  ...
)
}
\arguments{
\item{league_id}{league_id}

\item{college}{college}

\item{overall_pick}{overall_pick}

\item{round_pick}{round_pick}

\item{round_num}{round_num}

\item{season}{season}

\item{team_id}{team_id}

\item{top_x}{top_x}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
Returns a named list of data frames: DraftHistory

\strong{DraftHistory}\tabular{ll}{
   col_name \tab types \cr
   PERSON_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   SEASON \tab character \cr
   ROUND_NUMBER \tab character \cr
   ROUND_PICK \tab character \cr
   OVERALL_PICK \tab character \cr
   DRAFT_TYPE \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_CITY \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   ORGANIZATION \tab character \cr
   ORGANIZATION_TYPE \tab character \cr
   PLAYER_PROFILE_FLAG \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Draft History}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{ wnba_drafthistory(season = most_recent_wnba_season() - 1)
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Draft Functions: 
\code{\link{wnba_draftboard}()},
\code{\link{wnba_draftcombinedrillresults}()},
\code{\link{wnba_draftcombinenonstationaryshooting}()},
\code{\link{wnba_draftcombineplayeranthro}()},
\code{\link{wnba_draftcombinespotshooting}()},
\code{\link{wnba_draftcombinestats}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Draft Functions}
