% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wnba_stats_boxscore.R
\name{wnba_boxscoretraditionalv2}
\alias{wnba_boxscoretraditionalv2}
\title{\strong{Get WNBA Stats API Boxscore Traditional V2}}
\usage{
wnba_boxscoretraditionalv2(
  game_id,
  start_period = 0,
  end_period = 14,
  start_range = 0,
  end_range = 0,
  range_type = 0,
  ...
)
}
\arguments{
\item{game_id}{Game ID}

\item{start_period}{start_period}

\item{end_period}{end_period}

\item{start_range}{start_range}

\item{end_range}{end_range}

\item{range_type}{range_type}

\item{...}{Additional arguments passed to an underlying function like httr.}
}
\value{
A list of data frames: PlayerStats, TeamStarterBenchStats, TeamStats

\strong{PlayerStats}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   PLAYER_ID \tab character \cr
   PLAYER_NAME \tab character \cr
   NICKNAME \tab character \cr
   START_POSITION \tab character \cr
   COMMENT \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TO \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
}


\strong{TeamStats}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TO \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
   PLUS_MINUS \tab character \cr
}


\strong{TeamStarterBenchStats}\tabular{ll}{
   col_name \tab types \cr
   GAME_ID \tab character \cr
   TEAM_ID \tab character \cr
   TEAM_NAME \tab character \cr
   TEAM_ABBREVIATION \tab character \cr
   TEAM_CITY \tab character \cr
   STARTERS_BENCH \tab character \cr
   MIN \tab character \cr
   FGM \tab character \cr
   FGA \tab character \cr
   FG_PCT \tab character \cr
   FG3M \tab character \cr
   FG3A \tab character \cr
   FG3_PCT \tab character \cr
   FTM \tab character \cr
   FTA \tab character \cr
   FT_PCT \tab character \cr
   OREB \tab character \cr
   DREB \tab character \cr
   REB \tab character \cr
   AST \tab character \cr
   STL \tab character \cr
   BLK \tab character \cr
   TO \tab character \cr
   PF \tab character \cr
   PTS \tab character \cr
}
}
\description{
\strong{Get WNBA Stats API Boxscore Traditional V2}

\strong{Get WNBA Stats API Boxscore Traditional V2}
}
\details{
\if{html}{\out{<div class="sourceCode r">}}\preformatted{  wnba_boxscoretraditionalv2(game_id = "1022200034")
}\if{html}{\out{</div>}}
}
\seealso{
Other WNBA Boxscore Functions: 
\code{\link{wnba_boxscoreadvancedv2}()},
\code{\link{wnba_boxscorefourfactorsv2}()},
\code{\link{wnba_boxscoremiscv2}()},
\code{\link{wnba_boxscoreplayertrackv2}()},
\code{\link{wnba_boxscorescoringv2}()},
\code{\link{wnba_boxscoresummaryv2}()},
\code{\link{wnba_boxscoreusagev2}()},
\code{\link{wnba_gamerotation}()},
\code{\link{wnba_hustlestatsboxscore}()}
}
\author{
Saiem Gilani
}
\concept{WNBA Boxscore Functions}
