% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocess.R
\name{extract_domain}
\alias{extract_domain}
\title{Extract the domain from URL}
\usage{
extract_domain(wt, varname = "url")
}
\arguments{
\item{wt}{webtrack data object.}

\item{varname}{character. Name of the column from which to extract the host.
Defaults to \code{"url"}.}
}
\value{
webtrack data.frame with the same columns as wt
and a new column called \code{'domain'}
(or, if varname not equal to \code{'url'}, \code{'<varname>_domain'})
}
\description{
\code{extract_domain()} adds the domain of a URL as a new column.
By "domain", we mean the "top private domain", i.e., the domain under
the public suffix (e.g., "\code{com}") as defined by the Public Suffix List.
See details.

Extracts the domain from urls.
}
\details{
We define a "web domain" in the common colloquial meaning, that is,
the part of an web address that identifies the person or organization in control.
is \code{google.com}. More technically, what we mean by "domain" is the
"top private domain", i.e., the domain under the public suffix,
as defined by the Public Suffix List.
Note that this definition sometimes leads to counterintuitive results because
not all public suffixes are "registry suffixes". That is, they are not controlled
by a domain name registrar, but allow users to directly register a domain.
One example of such a public, non-registry suffix is \code{blogspot.com}. For a URL like
\code{www.mysite.blogspot.com}, our function, and indeed the packages we are aware of,
would extract the domain as \code{mysite.blogspot.com}, although you might think of
\code{blogspot.com} as the domain.
For details, see \href{https://github.com/google/guava/wiki/InternetDomainNameExplained}{here}
}
\examples{
\dontrun{
data("testdt_tracking")
wt <- as.wt_dt(testdt_tracking)
# Extract domain and drop rows without domain
wt <- extract_domain(wt)
# Extract domain and keep rows without domain
wt <- extract_domain(wt)
}
}
