% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/align.R
\name{align}
\alias{align}
\title{Align templates and images}
\usage{
align(
  stimuli,
  pt1 = 0,
  pt2 = 1,
  x1 = NULL,
  y1 = NULL,
  x2 = NULL,
  y2 = NULL,
  width = NULL,
  height = NULL,
  ref_img = NULL,
  fill = wm_opts("fill"),
  procrustes = FALSE
)
}
\arguments{
\item{stimuli}{list of stimuli}

\item{pt1}{The first point to align (defaults to 0)}

\item{pt2}{The second point to align (defaults to 1)}

\item{x1, y1, x2, y2}{The coordinates to align the first and second point to}

\item{width, height}{The dimensions of the aligned images}

\item{ref_img}{The reference image to get coordinates and dimensions from if they are NULL}

\item{fill}{background color if cropping goes outside the original image, see \code{\link[=color_conv]{color_conv()}}}

\item{procrustes}{logical; whether to use procrustes alignment}
}
\value{
list of stimuli with aligned images and/or templates
}
\description{
Align images so that template points line up. Defaults to two-point alignment of the first two points in your template (usually the eyes) to their mean coordinate position across the stimuli.
}
\details{
Setting pt1 the same as pt2 aligns 1 point, but does not resize or rotate images. Setting pt1 and pt2 aligns 2 points, resizing and rotating faces. Setting \code{procrustes = TRUE} uses Procrustes analysis to resize and rotate images to be as close as possible to a mean shape.

You can specify the x and y coordinates to align, and the width and height of the output images, or set them from a reference image. The reference image (\code{ref_img}) can be a stim, a 1-item stimlist, or the index or name of a stim in stimuli. It defaults to average of all stimuli if NULL.

Visualise the template points with \code{\link[=draw_tem]{draw_tem()}} to determine which to align, using pt.shape = "index".
}
\examples{
# align eye points to specific x and y coordinates
# in a 300x300 pixel image
demo_unstandard(1:3) |>
  align(pt1 = 0, pt2 = 1,
        x1 = 100, x2 = 200, y1 = 100, y2 = 100, 
        width = 300, height = 300)

\donttest{
orig <- demo_unstandard()

# align to bottom-centre of nose (average position)
align(orig, pt1 = 55, pt2 = 55, fill = "dodgerblue")

# align to pupils of second image
align(orig, ref_img = 2, fill = "dodgerblue")
}

\dontrun{
# procrustes align to average position
# this requires XQuartz on mac and may not run on linux
align(orig, procrustes = TRUE, fill = "dodgerblue")
}
}
\seealso{
Stimulus manipulation functions
\code{\link{crop_tem}()},
\code{\link{crop}()},
\code{\link{greyscale}()},
\code{\link{horiz_eyes}()},
\code{\link{image_func}()},
\code{\link{mask_oval}()},
\code{\link{mask}()},
\code{\link{mirror}()},
\code{\link{pad}()},
\code{\link{resize}()},
\code{\link{rotate}()},
\code{\link{to_size}()}
}
\concept{manipulators}
