% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_legend.R
\name{add_legend}
\alias{add_legend}
\title{Add legend to a web map}
\usage{
add_legend(
  map,
  labels,
  colors,
  radius,
  opacity = 0.5,
  symbol = c("square", "circle"),
  title = "EXPLANATION",
  position = "topright"
)
}
\arguments{
\item{map}{'\link{leaflet}'.
Map widget object}

\item{labels}{'character' vector.
Labels in the legend.}

\item{colors}{'character' vector.
HTML colors corresponding to \code{labels}.}

\item{radius}{'numeric' number.
Border radius of symbols in the legend, in pixels.}

\item{opacity}{'numeric' number.
Opacity of symbols in the legend, from 0 to 1.}

\item{symbol}{'character' string.
Symbol type in the legend, either "square" or "circle".}

\item{title}{'character' string.
Legend title}

\item{position}{'character' string.
Position of the button on the web map.
Possible values are "topleft", "topright", "bottomleft", and "bottomright".}
}
\value{
A new HTML web \code{map} with added element, an object of class 'leaflet'.
}
\description{
Add a legend to a \href{https://leafletjs.com/}{Leaflet} map.
}
\examples{
# define marker colors based on whether a city serves as a capital
colors <- c(
  "Non-capital" = "green",
  "Capital" = "red"
)
fill_colors <- colors[(us_cities$capital > 0) + 1L] |>
  as.character()

# print map with city circle markers and a map legend
make_map(maps = "Topo") |>
  leaflet::addCircleMarkers(
    lng = ~lng,
    lat = ~lat,
    radius = 6,
    color = "white",
    weight = 1,
    opacity = 1,
    fillColor = fill_colors,
    fillOpacity = 1,
    fill = TRUE,
    data = us_cities
  ) |>
  add_legend(
    labels = names(colors),
    colors = colors,
    radius = 5,
    opacity = 1,
    symbol = "circle"
  )
}
\seealso{
\code{\link{make_map}} function for creating a map widget.
}
\author{
J.C. Fisher, U.S. Geological Survey, Idaho Water Science Center
}
