% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/webdav.R
\name{webdav_delete_resource}
\alias{webdav_delete_resource}
\title{Delete a file or directory from the WebDAV server}
\usage{
webdav_delete_resource(
  base_url,
  resource_path,
  username = Sys.getenv("WEBDAV_USERNAME"),
  password = Sys.getenv("WEBDAV_PASSWORD"),
  verbose = FALSE
)
}
\arguments{
\item{base_url}{The base URL of the WebDAV server.}

\item{resource_path}{The path of the file or directory to delete on the WebDAV server.}

\item{username}{The username for WebDAV authentication. Defaults to the "WEBDAV_USERNAME" environment variable.}

\item{password}{The password for WebDAV authentication. Defaults to the "WEBDAV_PASSWORD" environment variable.}

\item{verbose}{Logical value indicating whether to print detailed debug messages. When TRUE, the function outputs additional information about its progress and actions.}
}
\value{
Logical value indicating whether the file or directory was deleted successfully.
}
\description{
This function deletes a file or directory on the WebDAV server using the DELETE method. It validates the provided parameters and handles errors during the process.
}
\examples{
# Example usage with a public WebDAV server.
# Visit test_server$url link to view the results of the operation.
library(magrittr)
library(httr2)
test_server <- "https://www.webdavserver.com/" \%>\%
  request() \%>\%
  req_retry(max_tries = 3, max_seconds = 4, backoff =  ~ 1) \%>\%
  req_perform() \%>\%
  try(silent = TRUE)

# Delete a file or directory
if (class(test_server) != "try-error")
  webdav_delete_resource(base_url = test_server$url, resource_path = "Notes.txt", verbose = TRUE)
}
