% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cts.R
\name{cts_convert}
\alias{cts_convert}
\title{Convert Ids using Chemical Translation Service (CTS)}
\usage{
cts_convert(
  query,
  from,
  to,
  first = FALSE,
  choices = NULL,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{query}{character; query ID.}

\item{from}{character; type of query ID, e.g. \code{'Chemical Name'} , \code{'InChIKey'},
\code{'PubChem CID'}, \code{'ChemSpider'}, \code{'CAS'}.}

\item{to}{character; type to convert to.}

\item{first}{deprecated.  Use choices = 1 instead.}

\item{choices}{to return only the first result, use 'choices = 1'.  To choose a result from an interative menu, provide a number of choices to choose from or "all".}

\item{verbose}{logical; should a verbose output be printed on the console?}

\item{...}{currently not used.}
}
\value{
a list of character vectors or if \code{choices} is used, then a single named vector.
}
\description{
Convert Ids using Chemical Translation Service (CTS), see \url{http://cts.fiehnlab.ucdavis.edu/}
}
\details{
See also \url{http://cts.fiehnlab.ucdavis.edu/}
for possible values of from and to.
}
\examples{
\donttest{
# might fail if API is not available
cts_convert("triclosan", "Chemical Name", "inchikey")

### multiple inputs
comp <- c("triclosan", "hexane")
cts_convert(comp, "Chemical Name", "cas")
}
}
\references{
Wohlgemuth, G., P. K. Haldiya, E. Willighagen, T. Kind, and O. Fiehn 2010The Chemical Translation Service
-- a Web-Based Tool to Improve Standardization of Metabolomic Reports. Bioinformatics 26(20): 2647–2648.
}
\seealso{
\code{\link{cts_from}} for possible values in the 'from' argument and
\code{\link{cts_to}} for possible values in the 'to' argument.
}
\author{
Eduard Szöcs, \email{eduardszoecs@gmail.com}
}
