% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo.R
\name{st_erase_overlaps}
\alias{st_erase_overlaps}
\title{Erase overlaps}
\usage{
st_erase_overlaps(x, verbose = FALSE)
}
\arguments{
\item{x}{\code{\link[sf]{sf}} object.}

\item{verbose}{\code{logical} should progress be reported? Defaults to
\code{FALSE}.}
}
\value{
\code{\link[sf]{sf}} object.
}
\description{
Erase overlapping geometries in a \code{\link[sf]{sf}} object.
}
\details{
This is a more robust---albeit slower---implementation for
  \code{\link{st_difference}} when \code{y} is missing.
}
\examples{
# create data
pl1 <- sf::st_polygon(list(matrix(c(0, 0, 2, 0, 1, 1, 0, 0), byrow = TRUE,
                                  ncol = 2))) * 100
pl2 <- sf::st_polygon(list(matrix(c(0, 0.5, 2, 0.5, 1, 1.5, 0, 0.5),
                                  byrow = TRUE, ncol = 2))) * 100
pl3 <- sf::st_polygon(list(matrix(c(0, 1.25, 2, 1.25, 1, 2.5, 0, 1.25),
                                  byrow = TRUE, ncol = 2))) * 100
x <- sf::st_sf(order = c("A", "B", "C"),
               geometry = sf::st_sfc(list(pl1, pl2, pl3), crs = 3395))

# erase overlaps
y <- st_erase_overlaps(x)

# plot data for visual comparison
par(mfrow = c(1, 2))
plot(sf::st_geometry(x), main = "original", col = "white")
plot(sf::st_geometry(y), main = "no overlaps", col = "white")
}
\seealso{
\code{\link[sf]{st_difference}}.
}
