% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rpanet_general.R
\name{rpanet_general}
\alias{rpanet_general}
\title{Generate a PA network with non-linear preference functions}
\usage{
rpanet_general(
  nstep,
  seednetwork,
  control,
  directed,
  m,
  sum_m,
  w,
  nnode,
  nedge,
  method,
  sample.recip
)
}
\arguments{
\item{nstep}{Number of steps when generating a network.}

\item{seednetwork}{A list represents the seed network. If \code{NULL},
\code{seednetwork} will have one edge from node 1 to node 2 with weight 1.
It consists of the following components: a two column matrix
\code{edgelist} represents the edges; a vector \code{edgeweight} represents
the weight of edges; a integer vector \code{nodegroup} represents the group
of nodes. \code{nodegroup} is defined for directed networks, if
\code{NULL}, all nodes from the seed graph are considered from group 1.}

\item{control}{A list of parameters that controls the PA generation process.
The default value is \code{rpactl.scenario() + rpactl.edgeweight() +
rpactl.newedge() + rpactl.preference() + rpactl.reciprocal()}. By
default, in each step, a new edge of weight 1 is added from a new node
\code{A} to an existing node \code{B} (\code{alpha} scenario), where
$\code{B} is chosen with probability proportional to its in-strength + 1.}

\item{directed}{Logical, whether to generate directed networks. If
\code{FALSE}, the edge directions are ignored.}

\item{m}{Integer vector, number of new edges in each step.}

\item{sum_m}{Integer, summation of \code{m}.}

\item{w}{Vector, weight of new edges.}

\item{nnode}{Integer, number of nodes in \code{seednetwork}.}

\item{nedge}{Integer, number of edges in \code{seednetwork}.}

\item{method}{Which method to use when generating PA networks: "binary" or
"naive".}

\item{sample.recip}{Whether reciprocal edges will be added.}
}
\value{
A list with the following components: \code{edgelist},
  \code{edgeweight}, \code{strength} for undirected networks,
  \code{outstrength} and \code{instrength} for directed networks, number of
  new edges in each step \code{newedge} (reciprocal edges are not included),
  control list
  \code{control}, node group \code{nodegroup} (if applicable) and edge
  scenario \code{scenario} (1~alpha, 2~beta, 3~gamma, 4~xi, 5~rho,
  6~reciprocal). The scenario of edges from \code{seednetwork} are denoted as
  0.
}
\description{
Generate a PA network with non-linear preference functions
}
