% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deprecated-wbsearch.R
\name{wbsearch}
\alias{wbsearch}
\title{Search indicator information available through the World Bank API}
\usage{
wbsearch(
  pattern = "poverty",
  fields = c("indicator", "indicatorDesc"),
  extra = FALSE,
  cache
)
}
\arguments{
\item{pattern}{Character string or regular expression to be matched}

\item{fields}{Character vector of column names through which to search}

\item{extra}{if \code{FALSE}, only the indicator ID and short name are returned,
if \code{TRUE}, all columns of the \code{cache} parameter's indicator data frame
are returned}

\item{cache}{List of data frames returned from \code{\link{wbcache}}. If omitted,
\code{\link{wb_cachelist_dep}} is used}
}
\value{
Data frame with indicators that match the search pattern.
}
\description{
This function allows finds indicators that match a search term and returns
a data frame of matching results
}
\examples{
wbsearch(pattern = "education")

wbsearch(pattern = "Food and Agriculture Organization", fields = "sourceOrg")

# with regular expression operators
# 'poverty' OR 'unemployment' OR 'employment'
wbsearch(pattern = "poverty|unemployment|employment")
}
