% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/area_of_applicability.R
\name{predict.ww_area_of_applicability}
\alias{predict.ww_area_of_applicability}
\title{Predict from a \code{ww_area_of_applicability}}
\usage{
\method{predict}{ww_area_of_applicability}(object, new_data, ...)
}
\arguments{
\item{object}{A \code{ww_area_of_applicability} object.}

\item{new_data}{A data frame or matrix of new samples.}

\item{...}{Not used.}
}
\value{
A tibble of predictions, with two columns: \code{di}, numeric, contains the
"dissimilarity index" of each point in \code{new_data}, while \code{aoa}, logical,
contains whether a row is inside (\code{TRUE}) or outside (\code{FALSE}) the area of
applicability.

Note that this function is often called using
\code{\link[terra:predict]{terra::predict()}}, in which case \code{aoa} will be converted to numeric
implicitly; \code{1} values correspond to cells "inside" the area of applicability
and \code{0} corresponds to cells "outside" the AOA.

The number of rows in the tibble is guaranteed
to be the same as the number of rows in \code{new_data}. Rows with \code{NA} predictor
values will have \code{NA} \code{di} and \code{aoa} values.
}
\description{
Predict from a \code{ww_area_of_applicability}
}
\details{
The function computes the distance indices of the new data and
whether or not they are "inside" the area of applicability.
}
\examples{
\dontshow{if (rlang::is_installed("vip")) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(vip)
train <- gen_friedman(1000, seed = 101) # ?vip::gen_friedman
test <- train[701:1000, ]
train <- train[1:700, ]
pp <- stats::ppr(y ~ ., data = train, nterms = 11)
metric_name <- ifelse(
  packageVersion("vip") > package_version("0.3.2"),
  "rsq",
  "rsquared"
)

importance <- vip::vi_permute(
  pp,
  target = "y",
  metric = metric_name,
  pred_wrapper = predict
)

aoa <- ww_area_of_applicability(y ~ ., train, test, importance = importance)
predict(aoa, test)
\dontshow{\}) # examplesIf}
}
\seealso{
Other area of applicability functions: 
\code{\link{ww_area_of_applicability}()}
}
\concept{area of applicability functions}
