% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/water_METRIC.R
\name{METRIC.Rn}
\alias{METRIC.Rn}
\title{Estimates Net Radiation as in METRIC Model}
\usage{
METRIC.Rn(image.DN, WeatherStation, MTL, sat = "auto", thermalband,
  alb.coeff = "Tasumi", LAI.method = "metric2010", plain = TRUE, DEM, aoi)
}
\arguments{
\item{image.DN}{raw imagen in digital counts to evaluate}

\item{WeatherStation}{Weather Station data, can be a waterWeatherStation 
object}

\item{MTL}{Landsat metadata file}

\item{sat}{Landsat satellite version. "L7" or "L8"}

\item{thermalband}{Landsat low gain thermalband}

\item{alb.coeff}{coefficient to transform narrow to broad band albedo.
See Details.}

\item{LAI.method}{Method used to estimate LAI from spectral data. 
See Details.}

\item{plain}{Logical. If TRUE surface is assumed plain}

\item{DEM}{Digital Elevation Model of the study area. Not needed
if plain = TRUE}

\item{aoi}{SpatialPolygon object with limits of Area of interest}
}
\description{
Estimates Net Radiation as in METRIC Model
}
\author{
Guillermo F Olmedo, \email{guillermo.olmedo@gmail.com}
}
\references{
R. G. Allen, M. Tasumi, and R. Trezza, "Satellite-based energy balance for mapping evapotranspiration with internalized calibration (METRIC) - Model" Journal of Irrigation and Drainage Engineering, vol. 133, p. 380, 2007
}

