% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/water_ET.R
\name{dailyET}
\alias{dailyET}
\title{Calculates daily ET using Penman Monteith hourly formula for every hour}
\usage{
dailyET(WeatherStation, DOY, height, lat, long, elev, ET = "ETo",
  long.z = WeatherStation$long)
}
\arguments{
\item{WeatherStation}{a data frame with all the needed fields (see example)}

\item{DOY}{day of year}

\item{height}{weather station sensors height in meters}

\item{lat}{latitude in decimal degrees of the weather station}

\item{long}{longitude in decimal degrees of the weather station}

\item{elev}{elevation in meters of the weather station}

\item{ET}{"ETo" or "ETr"}

\item{long.z}{longitude for local time}
}
\value{
ET      daily in mm.h-1
}
\description{
Calculates daily ET using Penman Monteith hourly formula for every hour
}
\examples{
csvfile <- system.file("extdata", "apples.csv", package="water")

WeatherStation <- read.WSdata(WSdata = csvfile, date.format = "\%d/\%m/\%Y",
lat=-35.42222, long= -71.38639, elev=201, height= 2.2, cf=c(1,0.2777778,1,1))

dailyET(WeatherStation = WeatherStation, lat=-35.422, long=-71.386, elev=124,
ET="ETo")
}
\author{
Guillermo Federico Olmedo
}
\references{
Allen 2005 ASCE
}

