% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/specan.R
\name{specan}
\alias{specan}
\title{Measure acoustic parameters in batches of sound files}
\usage{
specan(X, bp = c(0,22), wl = 512, threshold = 15, parallel = 1, fast = TRUE, path = NULL, 
pb = TRUE)
}
\arguments{
\item{X}{Data frame with the following columns: 1) "sound.files": name of the .wav 
files, 2) "sel": number of the selections, 3) "start": start time of selections, 4) "end": 
end time of selections. The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can
be used as the input data frame.}

\item{bp}{A numeric vector of length 2 for the lower and upper limits of a 
frequency bandpass filter (in kHz) or "frange" to indicate that values in low.f 
and high.f columns will be used as bandpass limits. Default is c(0, 22).}

\item{wl}{A numeric vector of length 1 specifying the spectrogram window length. Default is 512.}

\item{threshold}{amplitude threshold (\%) for fundamental frequency and 
dominant frequency detection. Default is 15.}

\item{parallel}{Numeric. Controls whether parallel computing is applied.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).
For windows OS the \code{parallelsugar} package should be installed.}

\item{fast}{Logical. If \code{TRUE} (default) then the peakf acoustic parameter (see below) is not computed, which 
substantially increases performance (~9 times faster).}

\item{path}{Character string containing the directory path where the sound files are located. 
If \code{NULL} (default) then the current working directory is used.}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}. Note that progress bar is only used
when parallel = 1.}
}
\value{
Data frame with the following acoustic parameters: 
\itemize{
   \item \code{duration}: length of signal
   \item \code{meanfreq}: mean frequency (in kHz)
   \item \code{sd}: standard deviation of frequency 
   \item \code{median}: median frequency (in kHz) 
   \item \code{Q25}: first quantile (in kHz) 
   \item \code{Q75}: third quantile (in kHz) 
   \item \code{IQR}: interquantile range (in kHz) 
   \item \code{skew}: skewness (see note in \code{\link[seewave]{specprop}} description) 
   \item \code{kurt}:  kurtosis (see note in \code{\link[seewave]{specprop}} description)
   \item \code{sp.ent}: spectral entropy 
   \item \code{sfm}: spectral flatness 
   \item \code{mode}: mode frequency
   \item \code{centroid}: frequency centroid (see \code{\link[seewave]{specprop}})
   \item \code{peakf}: peak frequency (frequency with highest energy) 
   \item \code{meanfun}: average of fundamental frequency measured across acoustic signal 
   \item \code{minfun}: minimum fundamental frequency measured across acoustic signal 
   \item \code{maxfun}: maximum fundamental frequency measured across acoustic signal 
   \item \code{meandom}: average of dominant frequency measured across acoustic signal 
   \item \code{mindom}: minimum of dominant frequency measured across acoustic signal
   \item \code{maxdom}: maximum of dominant frequency measured across acoustic signal 
   \item \code{dfrange}: range of dominant frequency measured across acoustic signal 
   \item \code{modindx}: modulation index. Calculated as the accumulated absolute 
     difference between adjacent measurements of dominant frequencies divided
     by the dominant frequency range
   \item \code{startdom}:  dominant frequency measurement at the start of the signal 
   \item \code{enddom}: dominant frequency measurement at the end of the signal 
   \item \code{dfslope}: slope of the change in dominant through time ([enddom-startdom]/duration)  
}
}
\description{
\code{specan} measures acoustic parameters on acoustic signals for which the start and end times 
are provided.
}
\details{
The ouptut of \code{\link{manualoc}} or \code{\link{autodetec}} can be used 
 directly without any additional modification. The function measures 25 acoustic parameters (if fast = \code{TRUE}) on 
 each selection in the data frame. Most parameters are produced internally by 
 \code{\link[seewave]{specprop}}, \code{\link[seewave]{fpeaks}}, \code{\link[seewave]{fund}},
 and \code{\link[seewave]{dfreq}} from the package seewave.
}
\examples{
\dontrun{
# First set temporary folder
setwd(tempdir())

data(list = c("Phae.long1", "Phae.long2", "Phae.long3", "Phae.long4", "selec.table"))
writeWave(Phae.long1,"Phae.long1.wav")
writeWave(Phae.long2,"Phae.long2.wav")
writeWave(Phae.long3,"Phae.long3.wav")
writeWave(Phae.long4,"Phae.long4.wav")

a <- specan(X = selec.table, bp = c(0, 22))

# using a diferent threshold
a <- specan(X = selec.table, bp = c(0, 22), threshold = 20)
# View(a)

}
}
\author{
Marcelo Araya-Salas (\email{araya-salas@cornell.edu}) and Grace Smith Vidaurre
}

