% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_annotations.R
\name{find_annotations}
\alias{find_annotations}
\title{Obtain annotations from 'audioblast.org' data base}
\usage{
find_annotations(qword, parallel = 1, pb = TRUE, warbler.format = FALSE)
}
\arguments{
\item{qword}{Character vector of length one indicating  the scientific name of the species to search for at audioblast's annotations database. For example, \emph{Phaethornis longirostris}.}

\item{parallel}{Numeric. Controls whether parallel computing is applied when downloading mp3 files.
It specifies the number of cores to be used. Default is 1 (i.e. no parallel computing).}

\item{pb}{Logical argument to control progress bar. Default is \code{TRUE}.}

\item{warbler.format}{Logical. If \code{TRUE} columns are renamed using the standard names for a selection table as in 'warbleR', frequency limit columns (high and low frequency) in 'Hz' are converted to 'kHz' (as in warbleR selection tables) and only the spectrogram view measurements are kept. Default is \code{FALSE}.}
}
\value{
A data frame with the annotation information.
}
\description{
\code{find_annotations} downloads sound file annotations and metadata from \href{https://audioblast.org/annotations/}{audioblast.org}.
}
\details{
This function queries for annotations on acoustic media in the open-access
online repository \href{https://audioblast.org/annotations/}{audioblast.org}.
}
\examples{
 \dontrun{
ann <- find_annotations(qword = "Amazilia brevirostris")
}
}
\references{
{
Araya-Salas, M., & Smith-Vidaurre, G. (2017). warbleR: An R package to streamline analysis of animal acoustic signals. Methods in Ecology and Evolution, 8(2), 184-191.
}
}
\seealso{
\code{\link{quer_xc}}
}
\author{
Marcelo Araya-Salas (\email{marceloa27@gmail.com})
}
