% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/xcmaps.R
\name{xcmaps}
\alias{xcmaps}
\title{Maps of Xeno-Canto recordings by species}
\usage{
xcmaps(X, img = TRUE, it = "jpeg")
}
\arguments{
\item{X}{Data frame output from \code{\link{querxc}}.}

\item{img}{A logical argument specifying whether an image file of each species
map should be returned, default is \code{TRUE}.}

\item{it}{A character vector of length 1 giving the image type to be used. Currently only
"tiff" and "jpeg" are admitted. Default is "jpeg".}
}
\value{
A map of Xeno-Canto recordings per species (image file), or a faceted
  plot of species map(s) in RStudio.
}
\description{
\code{xcmaps} creates maps to visualize the geographic spread of Xeno-Canto
  recordings.
}
\examples{
\dontrun{
X <- querxc("Phaethornis anthophilus", download = FALSE)
View(X)
xcmaps(X)
xcmaps(X, img = FALSE, it = "jpeg")
}
}
\author{
Marcelo Araya-Salas (\url{http://marceloarayasalas.weebly.com/}) and Grace Smith Vidaurre
}

