% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normal.R
\name{normal}
\alias{normal}
\alias{normal_round}
\title{Generate Random Normal Vector}
\usage{
normal(n, mean = 0, sd = 1, min = NULL, max = NULL, name = "Normal")

normal_round(n, mean = 0, sd = 1, min = NULL, max = NULL, digits = 2,
  name = "Normal")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{mean}{The mean value for the normal distribution to be drawn from.}

\item{sd}{The standard deviation of the normal distribution to draw from.}

\item{min}{A numeric lower boundary cutoff.  Results less than this value will be
replaced with \code{min}.}

\item{max}{A numeric upper boundary cutoff.  Results greater than this value will
be replaced with \code{max}.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}

\item{digits}{Integer indicating the number of decimal places to be used.
Negative values are allowed (see \code{\link[base]{round}}).}
}
\value{
Returns a random vector of elements.
}
\description{
\code{normal} - A wrapper for \code{\link[stats]{rnorm}} that generate a
random normal vector.

\code{normal_round} - A wrapper for \code{\link[stats]{rnorm}} that generate
a rounded random normal vector.
}
\examples{
normal(100, name = "Var")
hist(normal(10000, 100, 10))
interval(normal, 9, n = 1000)
}
\seealso{
\code{\link[stats]{rnorm}}

\code{\link[base]{round}}

Other variable functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dob}},
  \code{\link{dummy}}, \code{\link{education}},
  \code{\link{employment}}, \code{\link{eye}},
  \code{\link{grade_level}}, \code{\link{grade}},
  \code{\link{group}}, \code{\link{hair}},
  \code{\link{height}}, \code{\link{income}},
  \code{\link{internet_browser}}, \code{\link{iq}},
  \code{\link{language}}, \code{\link{level}},
  \code{\link{likert}}, \code{\link{lorem_ipsum}},
  \code{\link{marital}}, \code{\link{military}},
  \code{\link{month}}, \code{\link{name}},
  \code{\link{political}}, \code{\link{race}},
  \code{\link{religion}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{normal}
