% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/likert.R
\name{likert}
\alias{likert}
\alias{likert_5}
\alias{likert_7}
\title{Generate Random Vector of Likert-Type Responses}
\usage{
likert(n, x = c("Strongly Agree", "Agree", "Neutral", "Disagree",
  "Strongly Disagree"), prob = NULL, name = "Likert")

likert_5(n, x = c("Strongly Agree", "Agree", "Neutral", "Disagree",
  "Strongly Disagree"), prob = NULL, name = "Likert")

likert_7(n, x = c("Strongly Agree", "Agree", "Somewhat Agree", "Neutral",
  "Somewhat Disagree", "Disagree", "Strongly Disagree"), prob = NULL,
  name = "Likert")
}
\arguments{
\item{n}{The number elements to generate.  This can be globally set within
the environment of \code{r_data_frame} or \code{r_list}.}

\item{x}{A vector of elements to chose from.}

\item{prob}{A vector of probabilities to chose from.}

\item{name}{The name to assign to the output vector's \code{varname}
attribute.  This is used to auto assign names to the column/vector name when
used inside of \code{r_data_frame} or \code{r_list}.}
}
\value{
Returns a random vector of Likert-type response elements.
}
\description{
Generate a random vector of Likert-type responses.
}
\note{
\code{likert} & \code{likert_5} are identical outputs, sampling from a
5-point response scale.  \code{likert_7} samples from a 7-point response
scale.
}
\examples{
dice(10)
barplot(table(dice(10000)))
}
\seealso{
Other variable.functions: \code{\link{age}},
  \code{\link{animal}}, \code{\link{answer}},
  \code{\link{area}}, \code{\link{car}},
  \code{\link{children}}, \code{\link{coin}},
  \code{\link{color}}, \code{\link{date_stamp}},
  \code{\link{death}}, \code{\link{dice}},
  \code{\link{dna}}, \code{\link{dob}},
  \code{\link{dummy}}, \code{\link{education}},
  \code{\link{employment}}, \code{\link{eye}},
  \code{\link{grade_level}}, \code{\link{grade}},
  \code{\link{group}}, \code{\link{hair}},
  \code{\link{height}}, \code{\link{income}},
  \code{\link{internet_browser}}, \code{\link{iq}},
  \code{\link{language}}, \code{\link{level}},
  \code{\link{lorem_ipsum}}, \code{\link{marital}},
  \code{\link{military}}, \code{\link{month}},
  \code{\link{name}}, \code{\link{normal}},
  \code{\link{political}}, \code{\link{race}},
  \code{\link{religion}}, \code{\link{sat}},
  \code{\link{sentence}}, \code{\link{sex_inclusive}},
  \code{\link{sex}}, \code{\link{smokes}},
  \code{\link{speed}}, \code{\link{state}},
  \code{\link{string}}, \code{\link{upper}},
  \code{\link{valid}}, \code{\link{year}},
  \code{\link{zip_code}}
}
\keyword{likert}
\keyword{responses}

