% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waiter.R
\name{waiter}
\alias{waiter}
\alias{use_waiter}
\alias{show_waiter}
\alias{hide_waiter}
\title{Waiter}
\usage{
use_waiter()

show_waiter(html = "", color = "#333e48", logo = "")

hide_waiter()
}
\arguments{
\item{html}{HTML content of waiter, generally a spinner, see \code{\link{spinners}}.}

\item{color}{Background color of loading screen.}

\item{logo}{Logo to display.}
}
\description{
Programatically show and hide loading screens.
}
\examples{
library(shiny)

ui <- fluidPage(
  use_waiter(),
  actionButton("show", "Show loading for 5 seconds")
)

server <- function(input, output, session){
  observeEvent(input$show, {
    show_waiter(
      tagList(
        spin_fading_circles(),
        "Loading ..."
      )
    )
    Sys.sleep(3)
    hide_waiter()
  })
}

if(interactive()) shinyApp(ui, server)

}
