% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/design_missing_Z.R
\name{prepare.simple_plan}
\alias{prepare.simple_plan}
\title{Prepare a simple treatment.}
\usage{
\method{prepare}{simple_plan}(treatmentplan, dframe, ...)
}
\arguments{
\item{treatmentplan}{A simple treatment plan.}

\item{dframe}{data.frame to be treated.}

\item{...}{not used, present for S3 signature consistency.}
}
\description{
Prepare a simple treatment.
}
\examples{

d <- wrapr::build_frame(
  "x1", "x2", "x3" |
  1   , 4   , "A"  |
  NA  , 5   , "B"  |
  3   , 6   , NA   )

plan <- design_missingness_treatment(d)
prepare(plan, d)

prepare(plan, data.frame(x1=NA, x2=NA, x3="E"))

}
\seealso{
\code{\link{design_missingness_treatment}}, \code{\link{prepare}}
}
