% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/release.R
\name{vsts_deploy_release}
\alias{vsts_deploy_release}
\title{Visual Studio Project Release Environment Information}
\usage{
vsts_deploy_release(domain, project, release, env, auth_key)
}
\arguments{
\item{domain}{the location of the visual studio server}

\item{project}{the name of the project in \code{domain} to look at}

\item{release}{the release ID of the release}

\item{env}{the release environment ID to release on}

\item{auth_key}{authentication key generated by using \code{\link{vsts_auth_key}}}
}
\description{
These functions will allow you to run release environment tasks from Visual Studio.
}
\details{
For more information about release environment API calls check
\url{https://docs.microsoft.com/en-us/rest/api/vsts/release/releases/update\%20release\%20environment}.
}
\examples{
#Add in own details to get a non-NULL output
auth_key <- vsts_auth_key('<username>', '<password>')
vsts_deploy_release('domain', 'project', auth_key, 1, 1)

}
