% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vpreprocess.R
\name{vol_preprocess}
\alias{vol_preprocess}
\title{Preprocess the data for downstream volume analysis.}
\usage{
vol_preprocess(X, col.norm = "sd", row.norm = NULL, pfactor = NULL)
}
\arguments{
\item{X}{A numeric matrix. Covariance is estimated for column vectors of \code{X}.}

\item{col.norm}{A character. Specifies column normalization strategy (by default "sd"). NULL to avoid normalization.}

\item{row.norm}{A character. Specifies row normalization strategy (by default NULL).}

\item{pfactor}{A numeric A factor to normalize co-occurence matrix (by default NULL).
Row normalization follows column normalization. NULL to avoid normalization.}
}
\value{
A list of objects that include normalized matrix \code{X.process}, row and column normalization factors \code{row.factors} and \code{col.factors},
covariance matrix \code{P0}, covariance matrix \code{P} normalized to maximum value \code{pfactor},
orthonormal basis \code{U} and vector of eigenvalues \code{eigens}.
}
\description{
\code{vol_preprocess} Routine normalizes the data (as requested), estimates covariance and SVD decomposition.
}
\examples{
small_example <- sim_factors(5, 5, 5)
vol <- vol_preprocess(t(small_example$X))

}
