% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_validators.R
\name{is.scanonevar}
\alias{is.scanonevar}
\alias{is.scanonevar.w.perms}
\alias{is.cross}
\alias{is.f2.cross}
\alias{is.f2.cross}
\alias{is.cross.w.genoprobs}
\title{is.scanonevar}
\usage{
is.scanonevar(x)

is.scanonevar.w.perms(x)

is.cross(x)

is.f2.cross(x)

is.f2.cross(x)

is.cross.w.genoprobs(x)
}
\arguments{
\item{x}{object being tested}
}
\value{
TRUE is X is a scanonevar object, FALSE otherwise.

TRUE if x is a scanone var with perms (typically,
outputted from scanonevar.perm), and FALSE otherwise.

TRUE if x is a cross object, FALSE otherwise.

TRUE if x is a cross object of type F2, FALSE otherwise

TRUE if x is a cross object of type 'bc' (backcross), FALSE otherwise

TRUE if x is a cross object with valid genoprobs for each chromosome,
FALSE otherwise
}
\description{
utilities for working with scanonevar objects
}
\examples{
is.scanonevar(x = 3)

test.cross <- qtl::sim.cross(map = qtl::sim.map(len = rep(20, 4), n.mar = 5))
test.cross <- qtl::calc.genoprob(cross = test.cross, step = 2)

x <- scanonevar(cross = test.cross)
is.scanonevar(x)

is.cross(3)
is.cross(qtl::sim.cross(map = qtl::sim.map()))

is.cross(3)
is.cross(qtl::sim.cross(map = qtl::sim.map()))

is.cross(3)
is.cross(qtl::sim.cross(map = qtl::sim.map()))

a <- qtl::sim.cross(map = qtl::sim.map())
is.cross.w.genoprobs(x = a)
b <- qtl::calc.genoprob(cross = a)
is.cross.w.genoprobs(x = b)

}
\author{
Robert W. Corty \email{rcorty@gmail.com}

Robert W. Corty \email{rcorty@gmail.com}

Robert W. Corty \email{rcorty@gmail.com}

Robert W. Corty \email{rcorty@gmail.com}

Robert W. Corty \email{rcorty@gmail.com}
}
