% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/EC_functions.R
\name{vpr_autoid_read}
\alias{vpr_autoid_read}
\title{Read VPR aid files}
\usage{
vpr_autoid_read(
  file_list_aid,
  file_list_aidmeas,
  export,
  station_of_interest,
  opticalSetting,
  warn = TRUE
)
}
\arguments{
\item{file_list_aid}{a list object of aid text files, containing roi strings. Output from matlab Visual Plankton software.}

\item{file_list_aidmeas}{a list object of aidmea text files, containing ROI measurements. Output from matlab Visual Plankton software.}

\item{export}{a character string specifying which type of data to output, either 'aid' (roi strings) or 'aidmeas' (measurement data)}

\item{station_of_interest}{Station information to be added to ROI data output, use NA if irrelevant}

\item{opticalSetting}{Optional argument specifying VPR optical setting. If provided will be used to convert size data into mm from pixels, if missing size data will be output in pixels}

\item{warn}{Logical, FALSE silences size data unit warnings}
}
\description{
Read aid text files containing ROI string information or measurement data and output as a dataframe
}
\details{
Only outputs either ROI string information OR measurement data but both file types must be provided
}
\note{
Full paths to each file should be specified
}
\examples{

station_of_interest <- 'test'
dayhour <- c('d222.h03', 'd222.h04')

#' #VPR OPTICAL SETTING (S0, S1, S2 OR S3)
opticalSetting <- "S2"
imageVolume <- 83663 #mm^3

auto_id_folder <- system.file('extdata/COR2019002/autoid/', package = 'vprr', mustWork = TRUE)
auto_id_path <- list.files(paste0(auto_id_folder, "/"), full.names = TRUE)

#'   # Path to aid for each taxa
aid_path <- paste0(auto_id_path, '/aid/')
# Path to mea for each taxa
aidmea_path <- paste0(auto_id_path, '/aidmea/')

# AUTO ID FILES
aid_file_list <- list()
aidmea_file_list <- list()
for (i in 1:length(dayhour)) {
  aid_file_list[[i]] <-
    list.files(aid_path, pattern = dayhour[[i]], full.names = TRUE)
  # SIZE DATA FILES
  aidmea_file_list[[i]] <-
    list.files(aidmea_path, pattern = dayhour[[i]], full.names = TRUE)
}

aid_file_list_all <- unlist(aid_file_list)
aidmea_file_list_all <- unlist(aidmea_file_list)

 # ROIs
roi_dat_combine <-
  vpr_autoid_read(
    file_list_aid = aid_file_list_all,
    file_list_aidmeas = aidmea_file_list_all,
    export = 'aid',
    station_of_interest = station_of_interest,
    opticalSetting = opticalSetting,
    warn = FALSE
  )

# MEASUREMENTS
roimeas_dat_combine <-
  vpr_autoid_read(
    file_list_aid = aid_file_list_all,
    file_list_aidmeas = aidmea_file_list_all,
    export = 'aidmeas',
    station_of_interest = station_of_interest,
    opticalSetting = opticalSetting,
    warn = FALSE
 )

}
\author{
E. Chisholm & K. Sorochan
}
