% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rparMap.R
\name{rparMap}
\alias{rparMap}
\title{Create parametric maps and residuals}
\usage{
rparMap(parameters, image, mask, method, ncores, mc.preschedule,
  outDir = NULL)
}
\arguments{
\item{parameters}{list of parametric and smooth table coefficients or ANOVA (like the output from vlmParam, vgamParam, anovalmVoxel)}

\item{image}{Input image of type 'nifti' or vector of path(s) to images. If multiple paths, the script will all mergeNifti() and merge across time.}

\item{mask}{Input mask of type 'nifti' or path to one. Must be a binary mask or a character. Must match the mask passed to one of vlmParam, vgamParam, vgamm4Param, vlmerParam}

\item{method}{which method of correction for multiple comparisons (default is none)}

\item{ncores}{Number of cores to use}

\item{mc.preschedule}{Argument to be passed to mclapply, whether or not to preschedule the jobs. More info in parallel::mclapply}

\item{outDir}{Path to the folder where to output parametric maps (Default is Null, only change if you want to write maps out)}
}
\value{
Return parametric maps of the fitted models
}
\description{
This function create parametric maps according from model parametric tables or analysis of variance tables. 
The function will return a p-map, t-map, signed z-map, p-adjusted-map for parametric terms and p-map, z-map, p-adjusted-map for smooth terms. 
Additionally the function will return a p-map, F-map, p-to-z-map, and p-adjusted-map if the input is ANOVA.
This function will return a residual map that can be used for cluster correction
You can select which type of p-value correction you want done on the map. The z-maps are signed just like FSL.
}
\examples{
image <- oro.nifti::nifti(img = array(1:1600, dim =c(4,4,4,25)))
mask <- oro.nifti::nifti(img = array(0:1, dim = c(4,4,4,1)))
set.seed(1)
covs <- data.frame(x = runif(25), y = runif(25))
fm1 <- "~ x + y"
models <- rlmParam(image=image, mask=mask, 
              formula=fm1, subjData=covs, ncores = 1)
Maps <- rparMap(models, image, mask, method="fdr", ncores = 1, mc.preschedule=TRUE)
}
\keyword{internal}
