% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vol2bird_config.R
\name{vol2bird_config}
\alias{vol2bird_config}
\title{Create a 'vol2bird' configuration instance}
\usage{
vol2bird_config(config)
}
\arguments{
\item{config}{a configuration instance to be copied.}
}
\value{
an object of class \code{Rcpp_Vol2BirdConfig}
}
\description{
Creates or copies a 'vol2bird' configuration instance of class \code{Rcpp_Vol2BirdConfig}
}
\details{
\subsection{Copying configuration instances}{

All processing options for \code{\link[=vol2bird]{vol2bird()}} are set using a configuration instance of class \code{Rcpp_Vol2BirdConfig}
In some cases it might be necessary to copy and modify configuration instance, for example
when processing polar volume files with different settings.
In these cases you can't copy the instance like:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{config<-vol2bird_config()
extra_config<-config
}\if{html}{\out{</div>}}

In the above example, the \code{config} and \code{extra_config} instances will both refer to the same object.
(copy by reference). To avoid this (and make a copy by value), use:

\if{html}{\out{<div class="sourceCode R">}}\preformatted{config<-vol2bird_config()
# create a copy identical to object config:
extra_config<-vol2bird_config(config)
}\if{html}{\out{</div>}}
}

\subsection{User configuration options}{

The \code{Rcpp_Vol2BirdConfig} class object sets the following 'vol2bird' processing options:
\itemize{
\item \code{azimMax}: Numeric. The minimum azimuth (0-360 degrees) used for constructing the bird density profile
\item \code{azimMin}: Numeric. The maximum azimuth (0-360 degrees) used for constructing the bird density profile
\item \code{birdRadarCrossSection}: Numeric. Radar cross section in cm^2
\item \code{clutterMap}: Character. clutter map path and filename
\item \code{clutterValueMin}: Numeric. sample volumes in the static cluttermap with a value above
this threshold will be considered clutter-contaminated. Default 0.1
\item \code{dbzType}: Character. Reflectivity factor quantity to use. Default \code{DBZH}
\item \code{dualPol}: Logical. Whether to use dual-pol moments for filtering meteorological echoes. Default \code{TRUE}
\item \code{elevMax}: Numeric. The minimum scan elevation in degrees used for constructing the bird density profile
\item \code{elevMin}: Numeric. The maximum scan elevation in degrees used for constructing the bird density profile
\item \code{layerThickness}: Numeric. The width/thickness of an altitude layer in m. Default 200
\item \code{mistNetPath}: Character. Path of 'MistNet' segmentation model in pytorch (.pt) format
\item \code{nLayers}: Integer. The number of layers in an altitude profile. Default 25
\item \code{radarWavelength}: Numeric. The radar wavelength in cm to assume when unavailable as an attribute in the input file. Default 5.3
\item \code{rangeMax}: Numeric. The maximum range in m used for constructing the bird density profile. Default 35000
\item \code{rangeMin}: Numeric. The minimum range in m used for constructing the bird density profile. Default 5000
\item \code{rhohvThresMin}: Numeric. Correlation coefficients higher than this threshold will be classified as precipitation. Default 0.95
\item \code{singlePol}: Logical. Whether to use single-pol moments for filtering meteorological echoes. Default \code{TRUE}
\item \code{stdDevMinBird}: Numeric. VVP Radial velocity standard deviation threshold. Default 2 m/s.
\item \code{useClutterMap}: Logical. Whether to use a static clutter map. Default \code{FALSE}
\item \code{useMistNet}: Logical. Whether to use the 'MistNet' segmentation model. Default \code{FALSE}.
}
}

\subsection{Advanced configuration options}{

Changing these settings is rarely needed.
\itemize{
\item \code{cellEtaMin}:  Numeric. Maximum mean reflectivity in cm^2/km^3 for cells containing birds
\item \code{cellStdDevMax}: Numeric. When analyzing precipitation cells, only cells for which the stddev of
vrad (aka the texture) is less than cellStdDevMax are considered in the rest of the analysis
\item \code{dbzThresMin}: Numeric. Minimum reflectivity factor of a gate to be considered for inclusion in a weather cell. Default 0 dBZ
\item \code{dealiasRecycle}: Logical. Whether we should dealias all data once (default \code{TRUE}), or dealias for each profile individually (\code{FALSE})
\item \code{dealiasVrad}: Logical. Whether we should dealias the radial velocities. Default \code{TRUE}.
\item \code{etaMax}: Numeric. Maximum reflectivity in cm^2/km^3 for single gates containing birds. Default 36000
\item \code{exportBirdProfileAsJSONVar}: Logical. Deprecated, do not use. Default \code{FALSE}
\item \code{fitVrad}: Logical. Whether or not to fit a model to the observed vrad. Default \code{TRUE}
\item \code{maxNyquistDealias}: Numeric. When all scans have nyquist velocity higher than this value, dealiasing is suppressed. Default 25 m/s.
\item \code{minNyquist}: Numeric. Scans with Nyquist velocity lower than this value are excluded. Default 5 m/s.
\item \code{mistNetElevs}: Numeric vector of length 5. Elevations to use in Cartesian projection for 'MistNet'. Default \code{c(0.5, 1.5, 2.5, 3.5, 4.5)}
\item \code{mistNetElevsOnly}: Logical. When \code{TRUE} (default), use only the specified elevation scans for 'MistNet' to calculate profile, otherwise use all available elevation scans
\item \code{requireVrad}: Logical. For a range gate to contribute it should have a valid radial velocity. Default \code{FALSE}
\item \code{resample}: Logical. Whether to resample the input polar volume. Downsampling speeds up the calculation. Default \code{FALSE}
\item \code{resampleNbins}: Numeric. Resampled number of range bins. Ignored when \code{resample} is \code{FALSE}. Default 100
\item \code{resampleNrays}: Numeric. Resampled number of azimuth bins. Ignored when \code{resample} is \code{FALSE}. Default 360
\item \code{resampleRscale}: Numeric. Resampled range gate length in m. Ignored when \code{resample} is \code{FALSE}. Default 500 m.
}
}

\subsection{Algorithm constants}{

Changing any of these constants is not recommended
\itemize{
\item \code{constant_absVDifMax}: Numeric. After fitting the radial velocity data, throw out any VRAD observations that
are more than absVDifMax away from the fitted value as outliers. Default 10
\item \code{constant_areaCellMin}: Numeric. When analyzing cells, areaCellMin determines the minimum size
of a cell to be considered in the rest of the analysis. in km^2. Default 0.5
\item \code{constant_cellClutterFractionMax}: Cells with clutter fractions above this value are likely not birds. Default 0.5
\item \code{constant_chisqMin}: Minimum standard deviation of the VVP fit. Default 1e-05
\item \code{constant_fringeDist}: Each identified weather cell is grown by a distance equal to 'fringeDist' using a region-growing approach. Default 5000
\item \code{constant_nAzimNeighborhood}: vrad's texture is calculated based on the local neighborhood. The neighborhood size in the azimuth direction is equal to this value. Default 3
\item \code{constant_nBinsGap}: When determining whether there are enough vrad observations in each direction, use nBinsGap sectors. Default 8
\item \code{constant_nCountMin}: The minimum number of neighbors for the texture value to be considered valid, as used in calcTexture(). Default 4
\item \code{constant_nNeighborsMin}: the minimum number of direct neighbors with dbz value above dbzThresMin as used in findWeatherCells(). Default 5
\item \code{constant_nObsGapMin}: there should be at least this many vrad observations in each sector. Default 5
\item \code{constant_nPointsIncludedMin}: when calculating the altitude-layer averaged dbz, there should be at least this many valid data points. Default 25
\item \code{constant_nRangNeighborhood}: vrad's texture is calculated based on the local neighborhood. The neighborhood size in the range direction is equal to this value. Default 3
\item \code{constant_refracIndex}: Refractive index of the scatterers. Default equal to water 0.964
\item \code{constant_vradMin}: When analyzing cells, radial velocities lower than vradMin are treated as clutter. Default 1 m/s.
}
}

\subsection{Debug printing options}{

Enable these printing options only for debugging purposes
in a terminal, since large amounts of data will be dumped into the console.
\itemize{
\item \code{printCell}: Logical. Print precipitation cell data to stderr. Default \code{FALSE}
\item \code{printCellProp}: Logical. Print precipitation cell properties to stderr. Default \code{FALSE}
\item \code{printClut}: Logical. Print clutter data to stderr. Default \code{FALSE}
\item \code{printDbz}: Logical. Print reflectivity factor data to stderr. Default \code{FALSE}
\item \code{printDealias}: Logical. \code{FALSE}
\item \code{printOptions}: Logical. Print options to stderr. Default \code{FALSE}
\item \code{printPointsArray}: Logical. Print the 'points' array to stderr. Default \code{FALSE}
\item \code{printProfileVar}: Logical. Print profile data to stderr. Default \code{FALSE}
\item \code{printRhohv}: Logical. Print correlation coefficient data to stderr. Default \code{FALSE}
\item \code{printTex}: Logical. Print radial velocity texture data to stderr. Default \code{FALSE}
\item \code{printVrad}: Logical. Print radial velocity data to stderr. Default \code{FALSE}
}
}
}
\examples{
# create a configuration instance
config <- vol2bird_config()
# list the the configuration elements:
config
# change the maximum range included in the profile generation to 40 km:
config$rangeMax <- 40000
# make a copy of the configuration instance:
config_copy <- vol2bird_config(config)
}
\seealso{
\itemize{
\item \code{\link[=vol2bird]{vol2bird()}}
}
}
