% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conv_mc.R
\name{conv_mc}
\alias{conv_mc}
\title{Convolute vectors using multicore.}
\usage{
conv_mc(
  y,
  compact.to,
  drop.zeros = FALSE,
  to.data.frame = FALSE,
  round.off = NULL,
  weight = NULL,
  mc.cores = 1
)
}
\arguments{
\item{y}{A numeric vector, matrix or data frame.}

\item{compact.to}{Percentage of remaining points after compression. If equals to 1 and keep.zeros = T, the original vector is presented.}

\item{drop.zeros}{Logical. Drop repeated zeros? Default: \code{FALSE}.}

\item{to.data.frame}{Logical. Convert to data frame? Default: \code{FALSE}.}

\item{round.off}{Number of decimal places of the convoluted vector. Default: \code{NULL}.}

\item{weight}{Vector of weights with same length of \code{y}. Default: \code{NULL}.}

\item{mc.cores}{The number of cores to mclapply. Default: \code{1}.}
}
\value{
A list of x and y convoluted values with length near to \code{compact.to*length(y)}.
}
\description{
Convolute vectors using multicore.
}
\examples{
library(voice)
# Same result of conv() function if x is a vector
conv(1:100, compact.to = 0.1, drop.zeros = TRUE, to.data.frame = FALSE)
conv_mc(1:100, compact.to = 0.1, drop.zeros = TRUE, to.data.frame = FALSE)

conv(1:100, compact.to = 0.1, drop.zeros = TRUE, to.data.frame = TRUE)
conv_mc(1:100, compact.to = 0.1, drop.zeros = TRUE, to.data.frame = TRUE)

# get path to audio file
path2wav <- list.files(system.file('extdata', package = 'wrassp'),
pattern <- glob2rx('*.wav'), full.names = TRUE)

\donttest{
# getting all features
M <- extract_features(dirname(path2wav), features = c('f0','formants',
'zcr','mhs','rms','gain','rfc','ac','cep','dft','css','lps','mfcc'),
mc.cores = 1, verbose = FALSE)

M.num <- M[,-(1:3)]
nrow(M.num)
cm1 <- conv_mc(M.num, compact.to = 0.1, drop.zeros = TRUE,
to.data.frame = FALSE, mc.cores = 1)
names(cm1)
lapply(cm1$f0, length)
}
}
\seealso{
\code{rm0}, \code{conv}, \code{conv_df}
}
