% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vmr-methods.R
\name{vmrMountDir}
\alias{vmrMountDir}
\title{Mount a host directory to guest}
\usage{
vmrMountDir(vmr, src = "", dest = "")
}
\arguments{
\item{vmr}{a \strong{vmr} object}

\item{src}{a host directory}

\item{dest}{a destination guest directory}
}
\value{
a \strong{vmr} object
}
\description{
Mount a host directory to the guest machine.
}
\details{
If the option of mounting a directory is available
in the guest provider, it will mount \emph{src} to \emph{destination} directory.
Calling with no arguments will disable this option.
}
\examples{
\dontrun{
boxes <- vmrList()
vmr <- vmrCreate(boxes$Name[1])
vmr <- vmrMountDir(vmr, src = getwd(), dest = "/vmr")
vmr <- vmrInitEnv(vmr)
vmrStart()
}
}
