% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ExampleDatasets.R
\docType{data}
\name{PTSD}
\alias{PTSD}
\title{Post Traumatic Stress Disorder data}
\format{
\describe{
   \item{subject}{Patient number}
   \item{control}{Self-control (A numeric vector)}
   \item{problems}{The number of life problems ( A numeric vector )}
   \item{stress}{The number of stress events ( A numeric vector )}
   \item{cohesion}{Family cohesion ( A numeric vector )}
   \item{time}{Measured at 3, 6 and 12 months after the fire ( 1 : 3 months, 2 : 6 months, 3 : 12 months )}
   \item{ptsd}{Post traumatic stress disorder, Outcome variable ( Categorical vector ) ( 0 : No, 1 : Yes)}
}
}
\source{
Allison (1991, chapter 8).
}
\usage{
data(PTSD)
}
\description{
This data of 316 patients who survived the fire, each patient was measured at 3, 6 and 12 months after the fire.
}
\details{
{
Control, problems, and stress were divided into upper and lower levels based on 3,
and cohesion was divided into upper and lower levels based on 6. ( 0 : Low, 1 : high )\cr
A data frame with 948 rows and 7 variables
\tabular{rccccccc}{
\strong{ } \tab \strong{subject} \tab \strong{control}  \tab \strong{problems} \tab \strong{stress} \tab \strong{cohesion} \tab \strong{time} \tab \strong{ptsd}\cr
1     \tab 15       \tab 3.22    \tab 5.62      \tab 1        \tab 8        \tab 1    \tab 0    \cr
2     \tab 15       \tab 3.17    \tab 5.38      \tab 0        \tab 8        \tab 2    \tab 0    \cr
3     \tab 15       \tab 3.28    \tab 3.75      \tab 1        \tab 8        \tab 3    \tab 0    \cr
4     \tab 18       \tab 2.56    \tab 9.25      \tab 0        \tab 8        \tab 1    \tab 1    \cr
5     \tab 18       \tab 3.44    \tab 4.38      \tab 0        \tab 8        \tab 2    \tab 0    \cr
6     \tab 18       \tab 3.33    \tab 2.38      \tab 0        \tab 8        \tab 3    \tab 0    \cr
7     \tab 19       \tab 2.72    \tab 7.75      \tab 1        \tab 8        \tab 1    \tab 1    \cr
8     \tab 19       \tab 2.78    \tab 7.75      \tab 1        \tab 7        \tab 2    \tab 1    \cr
9     \tab 19       \tab 2.78    \tab 7.50      \tab 1        \tab 7        \tab 3    \tab 0    \cr
\code{.} \tab\code{.}\tab\code{.}\tab\code{.}\tab \code{.} \tab\code{.}\tab\code{.}\tab\code{.} \cr
\code{.} \tab\code{.}\tab\code{.}\tab\code{.}\tab \code{.} \tab\code{.}\tab\code{.}\tab\code{.} \cr
\code{.} \tab\code{.}\tab\code{.}\tab\code{.}\tab \code{.} \tab\code{.}\tab\code{.}\tab\code{.} \cr
943   \tab 570      \tab 3.72    \tab 2.75      \tab 0        \tab 7        \tab 1    \tab 0    \cr
944   \tab 570      \tab 3.89    \tab 2.25      \tab 0        \tab 7        \tab 2    \tab 0    \cr
945   \tab 570      \tab 3.67    \tab 1.25      \tab 0        \tab 7        \tab 3    \tab 0    \cr
946   \tab 571      \tab 3.56    \tab 3.00      \tab 0        \tab 7        \tab 1    \tab 0    \cr
947   \tab 571      \tab 2.94    \tab 1.88      \tab 0        \tab 7        \tab 2    \tab 0    \cr
948   \tab 571      \tab 3.50    \tab 2.75      \tab 0        \tab 7        \tab 3    \tab 0    \cr
 }
}
}
\references{
Allison, P. D. (2001). \emph{Logistic Regression Using the SAS System, Theory and Application.} SAS Institute Inc.
}
\keyword{datasets}
