#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#include <rstan/rstaninc.hpp>
// Code generated by Stan version 2.17.0

#include <stan/model/model_header.hpp>

namespace model_visit_namespace {

using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::prob_grad;
using namespace stan::math;

typedef Eigen::Matrix<double,Eigen::Dynamic,1> vector_d;
typedef Eigen::Matrix<double,1,Eigen::Dynamic> row_vector_d;
typedef Eigen::Matrix<double,Eigen::Dynamic,Eigen::Dynamic> matrix_d;

static int current_statement_begin__;

stan::io::program_reader prog_reader__() {
    stan::io::program_reader reader;
    reader.add_event(0, 0, "start", "model_visit");
    reader.add_event(105, 105, "end", "model_visit");
    return reader;
}

template <typename T0__, typename T1__, typename T2__>
Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
ftheta(const T0__& ptox,
           const T1__& pres,
           const T2__& rho, std::ostream* pstream__) {
    typedef typename boost::math::tools::promote_args<T0__, T1__, T2__>::type fun_scalar_t__;
    typedef fun_scalar_t__ fun_return_scalar_t__;
    const static bool propto__ = true;
    (void) propto__;
        fun_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

    int current_statement_begin__ = -1;
    try {
        {
        current_statement_begin__ = 3;
        validate_non_negative_index("theta", "4", 4);
        Eigen::Matrix<fun_scalar_t__,Eigen::Dynamic,1>  theta(static_cast<Eigen::VectorXd::Index>(4));
        (void) theta;  // dummy to suppress unused var warning

        stan::math::initialize(theta, std::numeric_limits<double>::quiet_NaN());
        stan::math::fill(theta,DUMMY_VAR__);


        current_statement_begin__ = 4;
        if (as_bool(logical_eq(1,rho))) {

            current_statement_begin__ = 5;
            stan::math::assign(get_base1_lhs(theta,1,"theta",1), ((1 - ptox) * (1 - pres)));
            current_statement_begin__ = 6;
            stan::math::assign(get_base1_lhs(theta,2,"theta",1), ((1 - ptox) * pres));
            current_statement_begin__ = 7;
            stan::math::assign(get_base1_lhs(theta,3,"theta",1), (ptox * (1 - pres)));
            current_statement_begin__ = 8;
            stan::math::assign(get_base1_lhs(theta,4,"theta",1), (ptox * pres));
        } else {

            current_statement_begin__ = 10;
            stan::math::assign(get_base1_lhs(theta,4,"theta",1), ((-((sqrt((pow(((((ptox + pres) - (ptox * rho)) - (pres * rho)) - 1),2) - ((((4 * (rho - 1)) * ptox) * pres) * rho))) + ((((ptox + pres) - (ptox * rho)) - (pres * rho)) - 1))) / 2) / (rho - 1)));
            current_statement_begin__ = 13;
            if (as_bool(logical_lt(get_base1(theta,4,"theta",1),0))) {
                current_statement_begin__ = 14;
                stan::math::assign(get_base1_lhs(theta,4,"theta",1), 0);
            }
            current_statement_begin__ = 16;
            stan::math::assign(get_base1_lhs(theta,3,"theta",1), (ptox - get_base1(theta,4,"theta",1)));
            current_statement_begin__ = 17;
            if (as_bool(logical_lt(get_base1(theta,3,"theta",1),0))) {
                current_statement_begin__ = 18;
                stan::math::assign(get_base1_lhs(theta,3,"theta",1), 0);
            }
            current_statement_begin__ = 20;
            stan::math::assign(get_base1_lhs(theta,2,"theta",1), (pres - get_base1(theta,4,"theta",1)));
            current_statement_begin__ = 21;
            if (as_bool(logical_lt(get_base1(theta,2,"theta",1),0))) {
                current_statement_begin__ = 22;
                stan::math::assign(get_base1_lhs(theta,2,"theta",1), 0);
            }
            current_statement_begin__ = 24;
            stan::math::assign(get_base1_lhs(theta,1,"theta",1), (((rho * get_base1(theta,2,"theta",1)) * get_base1(theta,3,"theta",1)) / get_base1(theta,4,"theta",1)));
        }
        current_statement_begin__ = 27;
        stan::math::assign(theta, multiply(theta,(1 / sum(theta))));
        current_statement_begin__ = 28;
        return stan::math::promote_scalar<fun_return_scalar_t__>(theta);
        }
    } catch (const std::exception& e) {
        stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
        // Next line prevents compiler griping about no return
        throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
    }
}


struct ftheta_functor__ {
    template <typename T0__, typename T1__, typename T2__>
        Eigen::Matrix<typename boost::math::tools::promote_args<T0__, T1__, T2__>::type, Eigen::Dynamic,1>
    operator()(const T0__& ptox,
           const T1__& pres,
           const T2__& rho, std::ostream* pstream__) const {
        return ftheta(ptox, pres, rho, pstream__);
    }
};

class model_visit : public prob_grad {
private:
    int NDOSE;
    vector<double> TAU;
    vector<vector<double> > PAR;
    double SDALPHA;
    int NOBSLEVEL;
    vector<vector<int> > OBSY;
    int SINGLEALPHA;
    int SINGLERHO;
    int FIXRHOAT1;
public:
    model_visit(stan::io::var_context& context__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, 0, pstream__);
    }

    model_visit(stan::io::var_context& context__,
        unsigned int random_seed__,
        std::ostream* pstream__ = 0)
        : prob_grad(0) {
        ctor_body(context__, random_seed__, pstream__);
    }

    void ctor_body(stan::io::var_context& context__,
                   unsigned int random_seed__,
                   std::ostream* pstream__) {
        boost::ecuyer1988 base_rng__ =
          stan::services::util::create_rng(random_seed__, 0);
        (void) base_rng__;  // suppress unused var warning

        current_statement_begin__ = -1;

        static const char* function__ = "model_visit_namespace::model_visit";
        (void) function__;  // dummy to suppress unused var warning
        size_t pos__;
        (void) pos__;  // dummy to suppress unused var warning
        std::vector<int> vals_i__;
        std::vector<double> vals_r__;
        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        // initialize member variables
        try {
            current_statement_begin__ = 34;
            context__.validate_dims("data initialization", "NDOSE", "int", context__.to_vec());
            NDOSE = int(0);
            vals_i__ = context__.vals_i("NDOSE");
            pos__ = 0;
            NDOSE = vals_i__[pos__++];
            current_statement_begin__ = 36;
            validate_non_negative_index("TAU", "NDOSE", NDOSE);
            context__.validate_dims("data initialization", "TAU", "double", context__.to_vec(NDOSE));
            validate_non_negative_index("TAU", "NDOSE", NDOSE);
            TAU = std::vector<double>(NDOSE,double(0));
            vals_r__ = context__.vals_r("TAU");
            pos__ = 0;
            size_t TAU_limit_0__ = NDOSE;
            for (size_t i_0__ = 0; i_0__ < TAU_limit_0__; ++i_0__) {
                TAU[i_0__] = vals_r__[pos__++];
            }
            current_statement_begin__ = 38;
            validate_non_negative_index("PAR", "NDOSE", NDOSE);
            validate_non_negative_index("PAR", "4", 4);
            context__.validate_dims("data initialization", "PAR", "double", context__.to_vec(NDOSE,4));
            validate_non_negative_index("PAR", "NDOSE", NDOSE);
            validate_non_negative_index("PAR", "4", 4);
            PAR = std::vector<std::vector<double> >(NDOSE,std::vector<double>(4,double(0)));
            vals_r__ = context__.vals_r("PAR");
            pos__ = 0;
            size_t PAR_limit_1__ = 4;
            for (size_t i_1__ = 0; i_1__ < PAR_limit_1__; ++i_1__) {
                size_t PAR_limit_0__ = NDOSE;
                for (size_t i_0__ = 0; i_0__ < PAR_limit_0__; ++i_0__) {
                    PAR[i_0__][i_1__] = vals_r__[pos__++];
                }
            }
            current_statement_begin__ = 40;
            context__.validate_dims("data initialization", "SDALPHA", "double", context__.to_vec());
            SDALPHA = double(0);
            vals_r__ = context__.vals_r("SDALPHA");
            pos__ = 0;
            SDALPHA = vals_r__[pos__++];
            current_statement_begin__ = 43;
            context__.validate_dims("data initialization", "NOBSLEVEL", "int", context__.to_vec());
            NOBSLEVEL = int(0);
            vals_i__ = context__.vals_i("NOBSLEVEL");
            pos__ = 0;
            NOBSLEVEL = vals_i__[pos__++];
            current_statement_begin__ = 45;
            validate_non_negative_index("OBSY", "(NOBSLEVEL + 1)", (NOBSLEVEL + 1));
            validate_non_negative_index("OBSY", "4", 4);
            context__.validate_dims("data initialization", "OBSY", "int", context__.to_vec((NOBSLEVEL + 1),4));
            validate_non_negative_index("OBSY", "(NOBSLEVEL + 1)", (NOBSLEVEL + 1));
            validate_non_negative_index("OBSY", "4", 4);
            OBSY = std::vector<std::vector<int> >((NOBSLEVEL + 1),std::vector<int>(4,int(0)));
            vals_i__ = context__.vals_i("OBSY");
            pos__ = 0;
            size_t OBSY_limit_1__ = 4;
            for (size_t i_1__ = 0; i_1__ < OBSY_limit_1__; ++i_1__) {
                size_t OBSY_limit_0__ = (NOBSLEVEL + 1);
                for (size_t i_0__ = 0; i_0__ < OBSY_limit_0__; ++i_0__) {
                    OBSY[i_0__][i_1__] = vals_i__[pos__++];
                }
            }
            current_statement_begin__ = 48;
            context__.validate_dims("data initialization", "SINGLEALPHA", "int", context__.to_vec());
            SINGLEALPHA = int(0);
            vals_i__ = context__.vals_i("SINGLEALPHA");
            pos__ = 0;
            SINGLEALPHA = vals_i__[pos__++];
            current_statement_begin__ = 49;
            context__.validate_dims("data initialization", "SINGLERHO", "int", context__.to_vec());
            SINGLERHO = int(0);
            vals_i__ = context__.vals_i("SINGLERHO");
            pos__ = 0;
            SINGLERHO = vals_i__[pos__++];
            current_statement_begin__ = 50;
            context__.validate_dims("data initialization", "FIXRHOAT1", "int", context__.to_vec());
            FIXRHOAT1 = int(0);
            vals_i__ = context__.vals_i("FIXRHOAT1");
            pos__ = 0;
            FIXRHOAT1 = vals_i__[pos__++];

            // validate, data variables
            current_statement_begin__ = 34;
            check_greater_or_equal(function__,"NDOSE",NDOSE,0);
            current_statement_begin__ = 36;
            for (int k0__ = 0; k0__ < NDOSE; ++k0__) {
                check_greater_or_equal(function__,"TAU[k0__]",TAU[k0__],0);
            }
            current_statement_begin__ = 38;
            current_statement_begin__ = 40;
            check_greater_or_equal(function__,"SDALPHA",SDALPHA,0);
            current_statement_begin__ = 43;
            check_greater_or_equal(function__,"NOBSLEVEL",NOBSLEVEL,0);
            current_statement_begin__ = 45;
            for (int k0__ = 0; k0__ < (NOBSLEVEL + 1); ++k0__) {
                for (int k1__ = 0; k1__ < 4; ++k1__) {
                    check_greater_or_equal(function__,"OBSY[k0__][k1__]",OBSY[k0__][k1__],0);
                }
            }
            current_statement_begin__ = 48;
            check_greater_or_equal(function__,"SINGLEALPHA",SINGLEALPHA,0);
            current_statement_begin__ = 49;
            check_greater_or_equal(function__,"SINGLERHO",SINGLERHO,0);
            current_statement_begin__ = 50;
            check_greater_or_equal(function__,"FIXRHOAT1",FIXRHOAT1,0);
            // initialize data variables


            // validate transformed data

            // validate, set parameter ranges
            num_params_r__ = 0U;
            param_ranges_i__.clear();
            current_statement_begin__ = 54;
            validate_non_negative_index("alpha", "NDOSE", NDOSE);
            num_params_r__ += NDOSE;
            current_statement_begin__ = 55;
            validate_non_negative_index("rho", "NDOSE", NDOSE);
            num_params_r__ += NDOSE;
            current_statement_begin__ = 56;
            validate_non_negative_index("pres", "NDOSE", NDOSE);
            num_params_r__ += NDOSE;
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    ~model_visit() { }


    void transform_inits(const stan::io::var_context& context__,
                         std::vector<int>& params_i__,
                         std::vector<double>& params_r__,
                         std::ostream* pstream__) const {
        stan::io::writer<double> writer__(params_r__,params_i__);
        size_t pos__;
        (void) pos__; // dummy call to supress warning
        std::vector<double> vals_r__;
        std::vector<int> vals_i__;

        if (!(context__.contains_r("alpha")))
            throw std::runtime_error("variable alpha missing");
        vals_r__ = context__.vals_r("alpha");
        pos__ = 0U;
        validate_non_negative_index("alpha", "NDOSE", NDOSE);
        context__.validate_dims("initialization", "alpha", "double", context__.to_vec(NDOSE));
        std::vector<double> alpha(NDOSE,double(0));
        for (int i0__ = 0U; i0__ < NDOSE; ++i0__)
            alpha[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < NDOSE; ++i0__)
            try {
            writer__.scalar_unconstrain(alpha[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable alpha: ") + e.what());
        }

        if (!(context__.contains_r("rho")))
            throw std::runtime_error("variable rho missing");
        vals_r__ = context__.vals_r("rho");
        pos__ = 0U;
        validate_non_negative_index("rho", "NDOSE", NDOSE);
        context__.validate_dims("initialization", "rho", "double", context__.to_vec(NDOSE));
        std::vector<double> rho(NDOSE,double(0));
        for (int i0__ = 0U; i0__ < NDOSE; ++i0__)
            rho[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < NDOSE; ++i0__)
            try {
            writer__.scalar_lb_unconstrain(0,rho[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable rho: ") + e.what());
        }

        if (!(context__.contains_r("pres")))
            throw std::runtime_error("variable pres missing");
        vals_r__ = context__.vals_r("pres");
        pos__ = 0U;
        validate_non_negative_index("pres", "NDOSE", NDOSE);
        context__.validate_dims("initialization", "pres", "double", context__.to_vec(NDOSE));
        std::vector<double> pres(NDOSE,double(0));
        for (int i0__ = 0U; i0__ < NDOSE; ++i0__)
            pres[i0__] = vals_r__[pos__++];
        for (int i0__ = 0U; i0__ < NDOSE; ++i0__)
            try {
            writer__.scalar_lub_unconstrain(9.9999999999999995e-08,0.99999998999999995,pres[i0__]);
        } catch (const std::exception& e) { 
            throw std::runtime_error(std::string("Error transforming variable pres: ") + e.what());
        }

        params_r__ = writer__.data_r();
        params_i__ = writer__.data_i();
    }

    void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                         std::ostream* pstream__) const {
      std::vector<double> params_r_vec;
      std::vector<int> params_i_vec;
      transform_inits(context, params_i_vec, params_r_vec, pstream__);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r(i) = params_r_vec[i];
    }


    template <bool propto__, bool jacobian__, typename T__>
    T__ log_prob(vector<T__>& params_r__,
                 vector<int>& params_i__,
                 std::ostream* pstream__ = 0) const {

        T__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        T__ lp__(0.0);
        stan::math::accumulator<T__> lp_accum__;

        try {
            // model parameters
            stan::io::reader<T__> in__(params_r__,params_i__);

            vector<T__> alpha;
            size_t dim_alpha_0__ = NDOSE;
            alpha.reserve(dim_alpha_0__);
            for (size_t k_0__ = 0; k_0__ < dim_alpha_0__; ++k_0__) {
                if (jacobian__)
                    alpha.push_back(in__.scalar_constrain(lp__));
                else
                    alpha.push_back(in__.scalar_constrain());
            }

            vector<T__> rho;
            size_t dim_rho_0__ = NDOSE;
            rho.reserve(dim_rho_0__);
            for (size_t k_0__ = 0; k_0__ < dim_rho_0__; ++k_0__) {
                if (jacobian__)
                    rho.push_back(in__.scalar_lb_constrain(0,lp__));
                else
                    rho.push_back(in__.scalar_lb_constrain(0));
            }

            vector<T__> pres;
            size_t dim_pres_0__ = NDOSE;
            pres.reserve(dim_pres_0__);
            for (size_t k_0__ = 0; k_0__ < dim_pres_0__; ++k_0__) {
                if (jacobian__)
                    pres.push_back(in__.scalar_lub_constrain(9.9999999999999995e-08,0.99999998999999995,lp__));
                else
                    pres.push_back(in__.scalar_lub_constrain(9.9999999999999995e-08,0.99999998999999995));
            }


            // transformed parameters
            current_statement_begin__ = 60;
            validate_non_negative_index("ptox", "NDOSE", NDOSE);
            vector<T__> ptox(NDOSE);
            stan::math::initialize(ptox, DUMMY_VAR__);
            stan::math::fill(ptox,DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("theta", "4", 4);
            validate_non_negative_index("theta", "NDOSE", NDOSE);
            vector<Eigen::Matrix<T__,Eigen::Dynamic,1> > theta(NDOSE, (Eigen::Matrix<T__,Eigen::Dynamic,1> (static_cast<Eigen::VectorXd::Index>(4))));
            stan::math::initialize(theta, DUMMY_VAR__);
            stan::math::fill(theta,DUMMY_VAR__);


            current_statement_begin__ = 63;
            for (int i = 1; i <= NDOSE; ++i) {
                {
                current_statement_begin__ = 64;
                T__ r;
                (void) r;  // dummy to suppress unused var warning

                stan::math::initialize(r, DUMMY_VAR__);
                stan::math::fill(r,DUMMY_VAR__);
                current_statement_begin__ = 65;
                T__ a;
                (void) a;  // dummy to suppress unused var warning

                stan::math::initialize(a, DUMMY_VAR__);
                stan::math::fill(a,DUMMY_VAR__);


                current_statement_begin__ = 67;
                if (as_bool(logical_eq(1,FIXRHOAT1))) {

                    current_statement_begin__ = 68;
                    stan::math::assign(r, 1);
                } else if (as_bool(logical_eq(1,SINGLERHO))) {

                    current_statement_begin__ = 70;
                    stan::math::assign(r, get_base1(rho,1,"rho",1));
                } else {

                    current_statement_begin__ = 72;
                    stan::math::assign(r, get_base1(rho,i,"rho",1));
                }
                current_statement_begin__ = 75;
                if (as_bool(logical_eq(1,SINGLEALPHA))) {

                    current_statement_begin__ = 76;
                    stan::math::assign(a, get_base1(alpha,1,"alpha",1));
                } else {

                    current_statement_begin__ = 78;
                    stan::math::assign(a, get_base1(alpha,i,"alpha",1));
                }
                current_statement_begin__ = 81;
                stan::math::assign(get_base1_lhs(ptox,i,"ptox",1), pow(get_base1(TAU,i,"TAU",1),exp(a)));
                current_statement_begin__ = 82;
                stan::math::assign(get_base1_lhs(theta,i,"theta",1), ftheta(get_base1(ptox,i,"ptox",1),get_base1(pres,i,"pres",1),r, pstream__));
                }
            }

            // validate transformed parameters
            for (int i0__ = 0; i0__ < NDOSE; ++i0__) {
                if (stan::math::is_uninitialized(ptox[i0__])) {
                    std::stringstream msg__;
                    msg__ << "Undefined transformed parameter: ptox" << '[' << i0__ << ']';
                    throw std::runtime_error(msg__.str());
                }
            }
            for (int i0__ = 0; i0__ < NDOSE; ++i0__) {
                for (int i1__ = 0; i1__ < 4; ++i1__) {
                    if (stan::math::is_uninitialized(theta[i0__](i1__))) {
                        std::stringstream msg__;
                        msg__ << "Undefined transformed parameter: theta" << '[' << i0__ << ']' << '[' << i1__ << ']';
                        throw std::runtime_error(msg__.str());
                    }
                }
            }

            const char* function__ = "validate transformed params";
            (void) function__;  // dummy to suppress unused var warning
            current_statement_begin__ = 60;
            for (int k0__ = 0; k0__ < NDOSE; ++k0__) {
                check_greater_or_equal(function__,"ptox[k0__]",ptox[k0__],9.9999999999999995e-08);
                check_less_or_equal(function__,"ptox[k0__]",ptox[k0__],0.99999998999999995);
            }
            current_statement_begin__ = 61;
            for (int k0__ = 0; k0__ < NDOSE; ++k0__) {
                check_greater_or_equal(function__,"theta[k0__]",theta[k0__],0);
                check_less_or_equal(function__,"theta[k0__]",theta[k0__],1);
            }

            // model body

            current_statement_begin__ = 89;
            lp_accum__.add(normal_log<propto__>(get_base1(alpha,1,"alpha",1), 0, SDALPHA));
            current_statement_begin__ = 90;
            for (int i = 2; i <= NDOSE; ++i) {

                current_statement_begin__ = 91;
                lp_accum__.add(normal_log<propto__>(get_base1(alpha,i,"alpha",1), get_base1(alpha,(i - 1),"alpha",1), SDALPHA));
            }
            current_statement_begin__ = 94;
            for (int i = 1; i <= NDOSE; ++i) {

                current_statement_begin__ = 95;
                lp_accum__.add(beta_log<propto__>(get_base1(pres,i,"pres",1), get_base1(get_base1(PAR,i,"PAR",1),1,"PAR",2), get_base1(get_base1(PAR,i,"PAR",1),2,"PAR",2)));
                current_statement_begin__ = 96;
                lp_accum__.add(lognormal_log<propto__>(get_base1(rho,i,"rho",1), get_base1(get_base1(PAR,i,"PAR",1),3,"PAR",2), get_base1(get_base1(PAR,i,"PAR",1),4,"PAR",2)));
            }
            current_statement_begin__ = 100;
            if (as_bool(logical_lt(0,NOBSLEVEL))) {

                current_statement_begin__ = 101;
                for (int i = 1; i <= NOBSLEVEL; ++i) {

                    current_statement_begin__ = 102;
                    lp_accum__.add(multinomial_log<propto__>(get_base1(OBSY,i,"OBSY",1), get_base1(theta,i,"theta",1)));
                }
            }

        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }

        lp_accum__.add(lp__);
        return lp_accum__.sum();

    } // log_prob()

    template <bool propto, bool jacobian, typename T_>
    T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
               std::ostream* pstream = 0) const {
      std::vector<T_> vec_params_r;
      vec_params_r.reserve(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        vec_params_r.push_back(params_r(i));
      std::vector<int> vec_params_i;
      return log_prob<propto,jacobian,T_>(vec_params_r, vec_params_i, pstream);
    }


    void get_param_names(std::vector<std::string>& names__) const {
        names__.resize(0);
        names__.push_back("alpha");
        names__.push_back("rho");
        names__.push_back("pres");
        names__.push_back("ptox");
        names__.push_back("theta");
    }


    void get_dims(std::vector<std::vector<size_t> >& dimss__) const {
        dimss__.resize(0);
        std::vector<size_t> dims__;
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dimss__.push_back(dims__);
        dims__.resize(0);
        dims__.push_back(NDOSE);
        dims__.push_back(4);
        dimss__.push_back(dims__);
    }

    template <typename RNG>
    void write_array(RNG& base_rng__,
                     std::vector<double>& params_r__,
                     std::vector<int>& params_i__,
                     std::vector<double>& vars__,
                     bool include_tparams__ = true,
                     bool include_gqs__ = true,
                     std::ostream* pstream__ = 0) const {
        vars__.resize(0);
        stan::io::reader<double> in__(params_r__,params_i__);
        static const char* function__ = "model_visit_namespace::write_array";
        (void) function__;  // dummy to suppress unused var warning
        // read-transform, write parameters
        vector<double> alpha;
        size_t dim_alpha_0__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < dim_alpha_0__; ++k_0__) {
            alpha.push_back(in__.scalar_constrain());
        }
        vector<double> rho;
        size_t dim_rho_0__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < dim_rho_0__; ++k_0__) {
            rho.push_back(in__.scalar_lb_constrain(0));
        }
        vector<double> pres;
        size_t dim_pres_0__ = NDOSE;
        for (size_t k_0__ = 0; k_0__ < dim_pres_0__; ++k_0__) {
            pres.push_back(in__.scalar_lub_constrain(9.9999999999999995e-08,0.99999998999999995));
        }
            for (int k_0__ = 0; k_0__ < NDOSE; ++k_0__) {
            vars__.push_back(alpha[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < NDOSE; ++k_0__) {
            vars__.push_back(rho[k_0__]);
            }
            for (int k_0__ = 0; k_0__ < NDOSE; ++k_0__) {
            vars__.push_back(pres[k_0__]);
            }

        if (!include_tparams__) return;
        // declare and define transformed parameters
        double lp__ = 0.0;
        (void) lp__;  // dummy to suppress unused var warning
        stan::math::accumulator<double> lp_accum__;

        double DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
        (void) DUMMY_VAR__;  // suppress unused var warning

        try {
            current_statement_begin__ = 60;
            validate_non_negative_index("ptox", "NDOSE", NDOSE);
            vector<double> ptox(NDOSE, 0.0);
            stan::math::initialize(ptox, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(ptox,DUMMY_VAR__);
            current_statement_begin__ = 61;
            validate_non_negative_index("theta", "4", 4);
            validate_non_negative_index("theta", "NDOSE", NDOSE);
            vector<vector_d> theta(NDOSE, (vector_d(static_cast<Eigen::VectorXd::Index>(4))));
            stan::math::initialize(theta, std::numeric_limits<double>::quiet_NaN());
            stan::math::fill(theta,DUMMY_VAR__);


            current_statement_begin__ = 63;
            for (int i = 1; i <= NDOSE; ++i) {
                {
                current_statement_begin__ = 64;
                double r(0.0);
                (void) r;  // dummy to suppress unused var warning

                stan::math::initialize(r, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(r,DUMMY_VAR__);
                current_statement_begin__ = 65;
                double a(0.0);
                (void) a;  // dummy to suppress unused var warning

                stan::math::initialize(a, std::numeric_limits<double>::quiet_NaN());
                stan::math::fill(a,DUMMY_VAR__);


                current_statement_begin__ = 67;
                if (as_bool(logical_eq(1,FIXRHOAT1))) {

                    current_statement_begin__ = 68;
                    stan::math::assign(r, 1);
                } else if (as_bool(logical_eq(1,SINGLERHO))) {

                    current_statement_begin__ = 70;
                    stan::math::assign(r, get_base1(rho,1,"rho",1));
                } else {

                    current_statement_begin__ = 72;
                    stan::math::assign(r, get_base1(rho,i,"rho",1));
                }
                current_statement_begin__ = 75;
                if (as_bool(logical_eq(1,SINGLEALPHA))) {

                    current_statement_begin__ = 76;
                    stan::math::assign(a, get_base1(alpha,1,"alpha",1));
                } else {

                    current_statement_begin__ = 78;
                    stan::math::assign(a, get_base1(alpha,i,"alpha",1));
                }
                current_statement_begin__ = 81;
                stan::math::assign(get_base1_lhs(ptox,i,"ptox",1), pow(get_base1(TAU,i,"TAU",1),exp(a)));
                current_statement_begin__ = 82;
                stan::math::assign(get_base1_lhs(theta,i,"theta",1), ftheta(get_base1(ptox,i,"ptox",1),get_base1(pres,i,"pres",1),r, pstream__));
                }
            }

            // validate transformed parameters
            current_statement_begin__ = 60;
            for (int k0__ = 0; k0__ < NDOSE; ++k0__) {
                check_greater_or_equal(function__,"ptox[k0__]",ptox[k0__],9.9999999999999995e-08);
                check_less_or_equal(function__,"ptox[k0__]",ptox[k0__],0.99999998999999995);
            }
            current_statement_begin__ = 61;
            for (int k0__ = 0; k0__ < NDOSE; ++k0__) {
                check_greater_or_equal(function__,"theta[k0__]",theta[k0__],0);
                check_less_or_equal(function__,"theta[k0__]",theta[k0__],1);
            }

            // write transformed parameters
            for (int k_0__ = 0; k_0__ < NDOSE; ++k_0__) {
            vars__.push_back(ptox[k_0__]);
            }
            for (int k_1__ = 0; k_1__ < 4; ++k_1__) {
                for (int k_0__ = 0; k_0__ < NDOSE; ++k_0__) {
                vars__.push_back(theta[k_0__][k_1__]);
                }
            }

            if (!include_gqs__) return;
            // declare and define generated quantities



            // validate generated quantities

            // write generated quantities
        } catch (const std::exception& e) {
            stan::lang::rethrow_located(e, current_statement_begin__, prog_reader__());
            // Next line prevents compiler griping about no return
            throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***");
        }
    }

    template <typename RNG>
    void write_array(RNG& base_rng,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                     Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                     bool include_tparams = true,
                     bool include_gqs = true,
                     std::ostream* pstream = 0) const {
      std::vector<double> params_r_vec(params_r.size());
      for (int i = 0; i < params_r.size(); ++i)
        params_r_vec[i] = params_r(i);
      std::vector<double> vars_vec;
      std::vector<int> params_i_vec;
      write_array(base_rng,params_r_vec,params_i_vec,vars_vec,include_tparams,include_gqs,pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i)
        vars(i) = vars_vec[i];
    }

    static std::string model_name() {
        return "model_visit";
    }


    void constrained_param_names(std::vector<std::string>& param_names__,
                                 bool include_tparams__ = true,
                                 bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pres" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ptox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= 4; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
    }


    void unconstrained_param_names(std::vector<std::string>& param_names__,
                                   bool include_tparams__ = true,
                                   bool include_gqs__ = true) const {
        std::stringstream param_name_stream__;
        for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "alpha" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "rho" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "pres" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }

        if (!include_gqs__ && !include_tparams__) return;
        for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
            param_name_stream__.str(std::string());
            param_name_stream__ << "ptox" << '.' << k_0__;
            param_names__.push_back(param_name_stream__.str());
        }
        for (int k_1__ = 1; k_1__ <= 4; ++k_1__) {
            for (int k_0__ = 1; k_0__ <= NDOSE; ++k_0__) {
                param_name_stream__.str(std::string());
                param_name_stream__ << "theta" << '.' << k_0__ << '.' << k_1__;
                param_names__.push_back(param_name_stream__.str());
            }
        }

        if (!include_gqs__) return;
    }

}; // model

}




#endif
