% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/add_quantiles.R
\name{add_quantiles}
\alias{add_quantiles}
\alias{add_quantiles.ggsurvfit}
\title{Add quantile indicators to visR plot}
\usage{
add_quantiles(gg, ...)

\method{add_quantiles}{ggsurvfit}(
  gg,
  quantiles = 0.5,
  linetype = "dashed",
  linecolour = "grey50",
  alpha = 1,
  ...
)
}
\arguments{
\item{gg}{A ggplot created with visR}

\item{...}{other arguments passed on to the method to modify \code{\link[ggplot2]{geom_line}}}

\item{quantiles}{vector of quantiles to be displayed on the probability scale, default: 0.5}

\item{linetype}{string indicating the linetype as described in the aesthetics of ggplot2 \code{\link[ggplot2]{geom_line}}, default: dashed (also supports "mixed" -> horizontal lines are solid, vertical ones are dashed)}

\item{linecolour}{string indicating the linetype as described in the aesthetics of ggplot2 \code{\link[ggplot2]{geom_line}}, default: grey, (also supports "strata" -> horizontal lines are grey50, vertical ones are the same colour as the respective strata)}

\item{alpha}{numeric value between 0 and 1 as described in the aesthetics of ggplot2 \code{\link[ggplot2]{geom_line}}, default: 1}
}
\value{
Lines indicating the quantiles overlayed on a visR ggplot
}
\description{
Method to add quantile lines to a plot.
}
\examples{

library(visR)

adtte \%>\%
  estimate_KM("SEX") \%>\%
  visr() \%>\%
  add_quantiles()

adtte \%>\%
  estimate_KM("SEX") \%>\%
  visr() \%>\%
  add_quantiles(quantiles = c(0.25, 0.50))

adtte \%>\%
  estimate_KM("SEX") \%>\%
  visr() \%>\%
  add_quantiles(
    quantiles = c(0.25, 0.50),
    linetype = "solid",
    linecolour = "grey"
  )

adtte \%>\%
  estimate_KM("SEX") \%>\%
  visr() \%>\%
  add_quantiles(
    quantiles = c(0.25, 0.50),
    linetype = "mixed",
    linecolour = "strata"
  )

}
