% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\title{Render a data.frame, risktable, or tableone object as a table}
\usage{
render(
  data,
  title = "",
  datasource,
  footnote = "",
  output_format = "html",
  engine = "gt",
  download_format = c("copy", "csv", "excel")
)
}
\arguments{
\item{data}{Input data.frame or tibble to visualize}

\item{title}{Specify the title as a text string to be displayed in the rendered table.
Default is no title.}

\item{datasource}{String specifying the data source underlying the data set.
Default is no title.}

\item{footnote}{String specifying additional information to be displayed as a footnote
alongside the data source and specifications of statistical tests.}

\item{output_format}{Type of output that is returned, can be "html" or "latex".
Default is "html".}

\item{engine}{If "html" is selected as \code{output_format}, one can chose between
using \code{kable}, \code{gt} and \code{DT} as engine to render the output table. Default is "gt".}

\item{download_format}{Options formats generated for downloading the data.
Default is a list "c('copy', 'csv', 'excel')".}
}
\value{
A table data structure with possible interactive functionality depending on the choice of the engine.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#questioning}{\figure{lifecycle-questioning.svg}{options: alt='[Questioning]'}}}{\strong{[Questioning]}}
Render a previously created data.frame, tibble or tableone object to html, rtf or latex
}
