% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/visSetOptions.R
\name{visSetOptions}
\alias{visSetOptions}
\title{Network visualization full options setter}
\usage{
visSetOptions(graph, options = NULL)
}
\arguments{
\item{graph}{: a visNetwork object}

\item{options}{: a named list with all options you want to add to your network.}
}
\description{
Network visualization full options setter. Using this function, you can pass all network options you want,
respecting the library format rather than use \link{visNodes}, \link{visEdges},  \link{visGroups}....
There is no control, so it's at your own risk !
}
\examples{
nodes <- data.frame(id = 1:3)
edges <- data.frame(from = c(1,2), to = c(1,3))

# using visNetwork functions
visNetwork(nodes, edges) \%>\% visNodes(shape = "square", color = "red") \%>\%
   visEdges(arrows = "to")

# directly use visSetOptions
visNetwork(nodes, edges) \%>\% 
 visSetOptions(options = list(nodes = list(shape = "square", color = "red"),
                              edges = list(arrows = "to")))



}
\references{
See online documentation \url{http://datastorm-open.github.io/visNetwork/}
}

