% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_anova.R
\name{vimp_anova}
\alias{vimp_anova}
\title{Nonparametric Intrinsic Variable Importance Estimates: ANOVA}
\usage{
vimp_anova(
  Y = NULL,
  X = NULL,
  cross_fitted_f1 = NULL,
  cross_fitted_f2 = NULL,
  indx = 1,
  V = 10,
  run_regression = TRUE,
  SL.library = c("SL.glmnet", "SL.xgboost", "SL.mean"),
  alpha = 0.05,
  delta = 0,
  na.rm = FALSE,
  cross_fitting_folds = NULL,
  stratified = FALSE,
  C = rep(1, length(Y)),
  Z = NULL,
  ipc_weights = rep(1, length(Y)),
  scale = "identity",
  ipc_est_type = "aipw",
  scale_est = TRUE,
  cross_fitted_se = TRUE,
  ...
)
}
\arguments{
\item{Y}{the outcome.}

\item{X}{the covariates. If \code{type = "average_value"}, then the exposure
variable should be part of \code{X}, with its name provided in \code{exposure_name}.}

\item{cross_fitted_f1}{the predicted values on validation data from a
flexible estimation technique regressing Y on X in the training data. Provided as
either (a) a vector, where each element is
the predicted value when that observation is part of the validation fold;
or (b) a list of length V, where each element in the list is a set of predictions on the
corresponding validation data fold.
If sample-splitting is requested, then these must be estimated specially; see Details.}

\item{cross_fitted_f2}{the predicted values on validation data from a
flexible estimation technique regressing either (a) the fitted values in
\code{cross_fitted_f1}, or (b) Y, on X withholding the columns in \code{indx}.
Provided as either (a) a vector, where each element is
the predicted value when that observation is part of the validation fold;
or (b) a list of length V, where each element in the list is a set of predictions on the
corresponding validation data fold.
If sample-splitting is requested, then these must be estimated specially; see Details.}

\item{indx}{the indices of the covariate(s) to calculate variable
importance for; defaults to 1.}

\item{V}{the number of folds for cross-fitting, defaults to 5. If
\code{sample_splitting = TRUE}, then a special type of \code{V}-fold cross-fitting
is done. See Details for a more detailed explanation.}

\item{run_regression}{if outcome Y and covariates X are passed to
\code{vimp_accuracy}, and \code{run_regression} is \code{TRUE},
then Super Learner will be used; otherwise, variable importance
will be computed using the inputted fitted values.}

\item{SL.library}{a character vector of learners to pass to
\code{SuperLearner}, if \code{f1} and \code{f2} are Y and X,
respectively. Defaults to \code{SL.glmnet}, \code{SL.xgboost},
and \code{SL.mean}.}

\item{alpha}{the level to compute the confidence interval at.
Defaults to 0.05, corresponding to a 95\% confidence interval.}

\item{delta}{the value of the \eqn{\delta}-null (i.e., testing if
importance < \eqn{\delta}); defaults to 0.}

\item{na.rm}{should we remove NAs in the outcome and fitted values
in computation? (defaults to \code{FALSE})}

\item{cross_fitting_folds}{the folds for cross-fitting. Only used if
\code{run_regression = FALSE}.}

\item{stratified}{if run_regression = TRUE, then should the generated
folds be stratified based on the outcome (helps to ensure class balance
across cross-validation folds)}

\item{C}{the indicator of coarsening (1 denotes observed, 0 denotes
unobserved).}

\item{Z}{either (i) NULL (the default, in which case the argument
\code{C} above must be all ones), or (ii) a character vector
specifying the variable(s) among Y and X that are thought to play a
role in the coarsening mechanism. To specify the outcome, use \code{"Y"}; to
specify covariates, use a character number corresponding to the desired
position in X (e.g., \code{"1"}).}

\item{ipc_weights}{weights for the computed influence curve (i.e.,
inverse probability weights for coarsened-at-random settings).
Assumed to be already inverted (i.e., ipc_weights = 1 / [estimated
probability weights]).}

\item{scale}{should CIs be computed on original ("identity") or
logit ("logit") scale?}

\item{ipc_est_type}{the type of procedure used for coarsened-at-random
settings; options are "ipw" (for inverse probability weighting) or
"aipw" (for augmented inverse probability weighting).
Only used if \code{C} is not all equal to 1.}

\item{scale_est}{should the point estimate be scaled to be greater than 0?
Defaults to \code{TRUE}.}

\item{cross_fitted_se}{should we use cross-fitting to estimate the standard
errors (\code{TRUE}, the default) or not (\code{FALSE})?}

\item{...}{other arguments to the estimation tool, see "See also".}
}
\value{
An object of classes \code{vim} and \code{vim_anova}.
  See Details for more information.
}
\description{
Compute estimates of and confidence intervals for nonparametric ANOVA-based
intrinsic variable importance. This is a wrapper function for \code{cv_vim},
with \code{type = "anova"}. This type
has limited functionality compared to other
types; in particular, null hypothesis tests
are not possible using \code{type = "anova"}.
If you want to do null hypothesis testing
on an equivalent population parameter, use
\code{vimp_rsquared} instead.
}
\details{
We define the population ANOVA
parameter for the group of features (or  single feature) \eqn{s} by
\deqn{\psi_{0,s} := E_0\{f_0(X) - f_{0,s}(X)\}^2/var_0(Y),}
where \eqn{f_0} is the population conditional mean using all features,
\eqn{f_{0,s}} is the population conditional mean using the features with
index not in \eqn{s}, and \eqn{E_0} and \eqn{var_0} denote expectation and
variance under the true data-generating distribution, respectively.

Cross-fitted ANOVA estimates are computed by first
splitting the data into \eqn{K} folds; then using each fold in turn as a
hold-out set, constructing estimators \eqn{f_{n,k}} and \eqn{f_{n,k,s}} of
\eqn{f_0} and \eqn{f_{0,s}}, respectively on the training data and estimator
\eqn{E_{n,k}} of \eqn{E_0} using the test data; and finally, computing
\deqn{\psi_{n,s} := K^{(-1)}\sum_{k=1}^K E_{n,k}\{f_{n,k}(X) - f_{n,k,s}(X)\}^2/var_n(Y),}
where \eqn{var_n} is the empirical variance.
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function.
}
\examples{
# generate the data
# generate X
p <- 2
n <- 100
x <- data.frame(replicate(p, stats::runif(n, -5, 5)))

# apply the function to the x's
smooth <- (x[,1]/5)^2*(x[,1]+7)/5 + (x[,2]/3)^2

# generate Y ~ Normal (smooth, 1)
y <- smooth + stats::rnorm(n, 0, 1)

# set up a library for SuperLearner; note simple library for speed
library("SuperLearner")
learners <- c("SL.glm", "SL.mean")

# estimate (with a small number of folds, for illustration only)
est <- vimp_anova(y, x, indx = 2,
           alpha = 0.05, run_regression = TRUE,
           SL.library = learners, V = 2, cvControl = list(V = 2))

}
\seealso{
\code{\link[SuperLearner]{SuperLearner}} for specific usage of the
  \code{SuperLearner} function and package.
}
