% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp_hypothesis_test.R
\name{vimp_hypothesis_test}
\alias{vimp_hypothesis_test}
\title{Perform a hypothesis test against the null hypothesis of \eqn{\delta} importance}
\usage{
vimp_hypothesis_test(
  predictiveness_full,
  predictiveness_reduced,
  se_full,
  se_reduced,
  delta = 0,
  alpha = 0.05
)
}
\arguments{
\item{predictiveness_full}{the estimated predictiveness of the regression including the covariate(s) of interest.}

\item{predictiveness_reduced}{the estimated predictiveness of the regression excluding the covariate(s) of interest.}

\item{se_full}{the estimated standard error for the predictiveness of the regression including the covariate(s) of interest.}

\item{se_reduced}{the estimated standard error for the predictiveness of the regression excluding the covariate(s) of interest.}

\item{delta}{the value of the \eqn{\delta}-null (i.e., testing if importance < \eqn{\delta}); defaults to 0.}

\item{alpha}{the desired type I error rate (defaults to 0.05).}
}
\value{
a list, with: the hypothesis testing decision (\code{TRUE} if the null hypothesis is rejected, \code{FALSE} otherwise); the p-value from the hypothesis test; and the test statistic from the hypothesis test.
}
\description{
Perform a hypothesis test against the null hypothesis of zero importance by:
(i) for a user-specified level \eqn{\alpha}, compute a \eqn{(1 - \alpha)\times 100}\% confidence interval around the predictiveness for both the full and reduced regression functions (these must be estimated on independent splits of the data);
(ii) if the intervals do not overlap, reject the null hypothesis.
}
\details{
See the paper by Williamson, Gilbert, Simon, and Carone for more
details on the mathematics behind this function and the definition of the parameter of interest.
}
